#ifndef CURRENCYEDIT_H
#define CURRENCYEDIT_H

#include <QMainWindow>
#include <QSettings>
#include <QModelIndex>
#include <QMessageBox>
#include "help.h"

namespace Ui {
    class CurrencyEdit;
}

class CurrencyEdit : public QMainWindow {
    Q_OBJECT
public:
    CurrencyEdit(QWidget *parent = 0);
    ~CurrencyEdit();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::CurrencyEdit *ui;    
    QSettings mvSettings;
    bool mvPegged;
    Help *helpWindow;

    void updateList();
    void clearFields();

private slots:
    void on_checkBox_Pegged_toggled(bool checked);
    void on_actionHelp_triggered();
    void on_pushButton_Restore_clicked();
    void on_pushButton_Remove_clicked();
    void on_pushButton_Add_clicked();
    void on_listWidget_clicked(QModelIndex index);
};

#endif // CURRENCYEDIT_H
