#ifndef TEXTBUTTON_H
#define TEXTBUTTON_H

#include <QGraphicsTextItem>
#include <QGraphicsObject>
#include <QColor>
#include "common.h"

class TextButton : public QGraphicsObject
{
    Q_OBJECT
public: 

    TextButton( const QString& buttonText,int size = 5 );

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );

    virtual QRectF boundingRect() const;

    virtual void setPressed( bool pressed );

    void mousePressEvent(QGraphicsSceneMouseEvent *event);

    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

signals:

    void clicked();

protected:
    bool mIsPressed;
    QGraphicsTextItem* mTextItem;
};

#endif // TEXTBUTTON_H
