/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Xavier Claessens <xavier.claessens@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __CONTACT_WINDOW_H__
#define __CONTACT_WINDOW_H__

#include <hildon/hildon.h>
#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS

#define CONTACT_TYPE_WINDOW (contact_window_get_type ())
#define CONTACT_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
    CONTACT_TYPE_WINDOW, ContactWindow))
#define CONTACT_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
    CONTACT_TYPE_WINDOW, ContactWindowClass))
#define CONTACT_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
    CONTACT_TYPE_WINDOW))
#define CONTACT_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
    CONTACT_TYPE_WINDOW))
#define CONTACT_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
    CONTACT_TYPE_WINDOW, ContactWindowClass))

typedef struct _ContactWindow ContactWindow;
typedef struct _ContactWindowClass ContactWindowClass;
typedef struct _ContactWindowPrivate ContactWindowPrivate;

struct _ContactWindow
{
  /*< private >*/
  HildonStackableWindow parent;
  ContactWindowPrivate *priv;
};

struct _ContactWindowClass
{
  HildonStackableWindowClass parent_class;
};

GType contact_window_get_type (void) G_GNUC_CONST;

GtkWidget *contact_window_new (OssoABookContact *contact);

G_END_DECLS

#endif /* __CONTACT_WINDOW_H__ */
