/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Xavier Claessens <xavier.claessens@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include <libosso-abook/osso-abook.h>

#include "contact-window.h"

typedef struct {
  OssoABookMenuExtension parent_instance;
} ContactViewPlugin;

typedef struct {
  OssoABookMenuExtensionClass parent_class;
} ContactViewPluginClass;

G_GNUC_INTERNAL GType contact_view_plugin_get_type (void) G_GNUC_CONST;
void contact_view_plugin_register (GTypeModule *module);

G_DEFINE_DYNAMIC_TYPE (ContactViewPlugin, contact_view_plugin,
    OSSO_ABOOK_TYPE_MENU_EXTENSION);

static void
contact_zoom_clicked_cb (GtkWidget *widget,
    OssoABookMenuExtension *self)
{
  OssoABookContact *contact;
  GtkWidget *window;

  contact = osso_abook_menu_extension_get_contact (self);
  if (contact == NULL)
    return;

  window = contact_window_new (contact);
  gtk_widget_show (window);
}

static void
contact_view_plugin_init (ContactViewPlugin *self)
{
}

static OssoABookMenuEntry entries[] = {
  { "Contact Zoom", 0, 0, G_CALLBACK (contact_zoom_clicked_cb), NULL },
};

static const OssoABookMenuEntry *
get_menu_entries (OssoABookMenuExtension *self)
{
  return entries;
}

static int
get_n_menu_entries (OssoABookMenuExtension *self)
{
  return G_N_ELEMENTS (entries);
}

void
contact_view_plugin_register (GTypeModule *module)
{
  contact_view_plugin_register_type (module);
}

static void
contact_view_plugin_class_init (ContactViewPluginClass *klass)
{
  OssoABookMenuExtensionClass *menu_extension_class;

  menu_extension_class = OSSO_ABOOK_MENU_EXTENSION_CLASS (klass);
  menu_extension_class->get_n_menu_entries = get_n_menu_entries;
  menu_extension_class->get_menu_entries = get_menu_entries;
  menu_extension_class->name = OSSO_ABOOK_MENU_NAME_CONTACT_VIEW;
}

static void
contact_view_plugin_class_finalize (ContactViewPluginClass *klass)
{
}
