#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QImage>
#include "ClassicPrint.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:
    void update_photo();
	void load_settings();
	void save_settings();

private:
    Ui::MainWindow *ui;
    QImage          m_photo;
	QImage			m_photo_full;
    ClassicPrint    m_print;
	QString			m_image_filename;

private slots:
    void on_btn_save_clicked();
    void on_btn_share_clicked();
    void on_btn_no_photo_clicked();
    void on_btn_edit_processing_clicked();
    void on_btn_edit_film_clicked();
    void on_btn_edit_lens_clicked();
    void on_actionOpen_Image_triggered();

    void progress(int percent);
};

#endif // MAINWINDOW_H
