/*
 *  Camera Launcher for Maemo.
 *  Copyright (C) 2010 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CL_UTILS_H
#define CL_UTILS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <glib/gi18n-lib.h>

#include <gtk/gtk.h>
#include <hildon/hildon.h>

#define CAMERA_APPLICATION_DESKTOP_FILE "camera-ui.desktop"
#define FCAMERA_DESKTOP_FILE "fcamera.desktop"
#define FLASHLIGHT_APPLET_DESKTOP_FILE "flashlight-applet-launcher.desktop"
#define FRONTVIEW_DESKTOP_FILE "frontview900.desktop"
#define MBARCODE_DESKTOP_FILE "mbarcode.desktop"
#define PANORAMA_DESKTOP_FILE "panorama.desktop"

#define GCONF_CL_LAUNCHER "/apps/maemo/cl-launcher"
#define CL_LAUNCHER_DESKTOP_DATADIR "/usr/share/applications/hildon"

typedef enum {
	CL_LAUNCHER_ACTION_RUN_PREFERED_APPLICATION = 0,
	CL_LAUNCHER_ACTION_SHOW_SELECTOR_POPUP,
	CL_LAUNCHER_ACTION_DO_NOTHING,
	CL_LAUNCHER_ACTION_LAST
} CLLauncherAction;

enum {
	SELECTOR_COLUMN_NAME = 0,
	SELECTOR_COLUMN_ICON,
	SELECTOR_COLUMN_FILENAME,
	SELECTOR_COLUMN_OSSO_SERVICE,
	SELECTOR_COLUMN_EXEC,
	NUM_COLS
};

typedef struct {
	gchar *icon;
	gchar *name;
	gchar *osso_service;
	gchar *exec;
} DesktopFileInfo;

gboolean get_application_list (GtkListStore *store);
gboolean get_application_list_from_list (GtkListStore *store, const GSList *list);

DesktopFileInfo *get_desktop_file_info (const gchar *desktop_file);

#endif /* CL_UTILS_H */
