#include <string.h>
#include <glib.h>

#include "rds.h"

/* This table comes from pyFMRadio source code. */
static const gunichar rds_table[256] = {
	0,	/* 0 */
	0,	/* 1 */
	0,	/* 2 */
	0,	/* 3 */
	0,	/* 4 */
	0,	/* 5 */
	0,	/* 6 */
	0,	/* 7 */
	0,	/* 8 */
	0,	/* 9 */
	0,	/* 10 */
	0,	/* 11 */
	0,	/* 12 */
	0,	/* 13 */
	0,	/* 14 */
	0,	/* 15 */
	0,	/* 16 */
	0,	/* 17 */
	0,	/* 18 */
	0,	/* 19 */
	0,	/* 20 */
	0,	/* 21 */
	0,	/* 22 */
	0,	/* 23 */
	0,	/* 24 */
	0,	/* 25 */
	0,	/* 26 */
	0,	/* 27 */
	0,	/* 28 */
	0,	/* 29 */
	0,	/* 30 */
	0,	/* 31 */
	32,	/* 32 */
	33,	/* 33 */
	34,	/* 34 */
	35,	/* 35 */
	164,	/* 36 */
	37,	/* 37 */
	38,	/* 38 */
	39,	/* 39 */
	40,	/* 40 */
	41,	/* 41 */
	42,	/* 42 */
	43,	/* 43 */
	44,	/* 44 */
	45,	/* 45 */
	46,	/* 46 */
	47,	/* 47 */
	48,	/* 48 */
	49,	/* 49 */
	50,	/* 50 */
	51,	/* 51 */
	52,	/* 52 */
	53,	/* 53 */
	54,	/* 54 */
	55,	/* 55 */
	56,	/* 56 */
	57,	/* 57 */
	58,	/* 58 */
	59,	/* 59 */
	60,	/* 60 */
	61,	/* 61 */
	62,	/* 62 */
	63,	/* 63 */
	64,	/* 64 */
	65,	/* 65 */
	66,	/* 66 */
	67,	/* 67 */
	68,	/* 68 */
	69,	/* 69 */
	70,	/* 70 */
	71,	/* 71 */
	72,	/* 72 */
	73,	/* 73 */
	74,	/* 74 */
	75,	/* 75 */
	76,	/* 76 */
	77,	/* 77 */
	78,	/* 78 */
	79,	/* 79 */
	80,	/* 80 */
	81,	/* 81 */
	82,	/* 82 */
	83,	/* 83 */
	84,	/* 84 */
	85,	/* 85 */
	86,	/* 86 */
	87,	/* 87 */
	88,	/* 88 */
	89,	/* 89 */
	90,	/* 90 */
	91,	/* 91 */
	92,	/* 92 */
	93,	/* 93 */
	32,	/* 94 */
	32,	/* 95 */
	32,	/* 96 */
	97,	/* 97 */
	98,	/* 98 */
	99,	/* 99 */
	100,	/* 100 */
	101,	/* 101 */
	102,	/* 102 */
	103,	/* 103 */
	104,	/* 104 */
	105,	/* 105 */
	106,	/* 106 */
	107,	/* 107 */
	108,	/* 108 */
	109,	/* 109 */
	110,	/* 110 */
	111,	/* 111 */
	112,	/* 112 */
	113,	/* 113 */
	114,	/* 114 */
	115,	/* 115 */
	116,	/* 116 */
	117,	/* 117 */
	118,	/* 118 */
	119,	/* 119 */
	120,	/* 120 */
	121,	/* 121 */
	122,	/* 122 */
	123,	/* 123 */
	124,	/* 124 */
	125,	/* 125 */
	32,	/* 126 */
	32,	/* 127 */
	225,	/* 128 */
	224,	/* 129 */
	233,	/* 130 */
	232,	/* 131 */
	237,	/* 132 */
	236,	/* 133 */
	243,	/* 134 */
	242,	/* 135 */
	250,	/* 136 */
	249,	/* 137 */
	209,	/* 138 */
	199,	/* 139 */
	350,	/* 140 */
	223,	/* 141 */
	161,	/* 142 */
	306,	/* 143 */
	226,	/* 144 */
	228,	/* 145 */
	234,	/* 146 */
	235,	/* 147 */
	238,	/* 148 */
	239,	/* 149 */
	244,	/* 150 */
	246,	/* 151 */
	251,	/* 152 */
	252,	/* 153 */
	241,	/* 154 */
	231,	/* 155 */
	351,	/* 156 */
	287,	/* 157 */
	63,	/* 158 */
	307,	/* 159 */
	170,	/* 160 */
	945,	/* 161 */
	169,	/* 162 */
	8240,	/* 163 */
	486,	/* 164 */
	277,	/* 165 */
	328,	/* 166 */
	337,	/* 167 */
	960,	/* 168 */
	63,	/* 169 */
	163,	/* 170 */
	36,	/* 171 */
	8592,	/* 172 */
	8593,	/* 173 */
	8594,	/* 174 */
	8595,	/* 175 */
	186,	/* 176 */
	185,	/* 177 */
	178,	/* 178 */
	179,	/* 179 */
	177,	/* 180 */
	304,	/* 181 */
	324,	/* 182 */
	369,	/* 183 */
	956,	/* 184 */
	191,	/* 185 */
	247,	/* 186 */
	176,	/* 187 */
	188,	/* 188 */
	189,	/* 189 */
	190,	/* 190 */
	167,	/* 191 */
	193,	/* 192 */
	192,	/* 193 */
	201,	/* 194 */
	200,	/* 195 */
	205,	/* 196 */
	204,	/* 197 */
	211,	/* 198 */
	210,	/* 199 */
	218,	/* 200 */
	217,	/* 201 */
	344,	/* 202 */
	268,	/* 203 */
	352,	/* 204 */
	381,	/* 205 */
	272,	/* 206 */
	317,	/* 207 */
	194,	/* 208 */
	196,	/* 209 */
	202,	/* 210 */
	203,	/* 211 */
	206,	/* 212 */
	207,	/* 213 */
	212,	/* 214 */
	214,	/* 215 */
	219,	/* 216 */
	220,	/* 217 */
	345,	/* 218 */
	269,	/* 219 */
	353,	/* 220 */
	382,	/* 221 */
	271,	/* 222 */
	318,	/* 223 */
	195,	/* 224 */
	197,	/* 225 */
	198,	/* 226 */
	338,	/* 227 */
	375,	/* 228 */
	221,	/* 229 */
	213,	/* 230 */
	216,	/* 231 */
	254,	/* 232 */
	330,	/* 233 */
	340,	/* 234 */
	262,	/* 235 */
	346,	/* 236 */
	377,	/* 237 */
	63,	/* 238 */
	240,	/* 239 */
	227,	/* 240 */
	229,	/* 241 */
	230,	/* 242 */
	339,	/* 243 */
	373,	/* 244 */
	253,	/* 245 */
	245,	/* 246 */
	248,	/* 247 */
	254,	/* 248 */
	331,	/* 249 */
	341,	/* 250 */
	263,	/* 251 */
	347,	/* 252 */
	378,	/* 253 */
	63,	/* 254 */
	32,	/* 255 */
};

gchar * rds_decode(const gchar *s)
{
	guint l = strlen(s);
	GString *b = g_string_sized_new(2 * l);

	guchar *c = (guchar*) s;
	while (*c) {
		g_string_append_unichar(b, rds_table[*c]);
		c++;
	}

	gchar *r = b->str;
	g_string_free(b, FALSE);
	return r;
}

