/*
 * Don Ceferino Hazaa - video game similary to Super Pang!
 * Copyright (c) 2004, 2005 Hugo Ruscitti
 * web site: http://www.loosersjuegos.com.ar
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Hugo Ruscitti <hugoruscitti@yahoo.com.ar>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <SDL/SDL.h>
#include <string.h>

#include "menu.h"
#include "mundo.h"
#include "grafico.h"
#include "utils.h"
#include "int.h"
#include "opciones.h"
#include "common.h"

#define GET_VALUE(x)	((x!=0) ? "On" : "Off")

/*!
 * \brief asigna los valores iniciales al menu opciones
 */
opciones :: opciones (void)
{
	tick_actual = SDL_GetTicks();
}	

opciones :: ~opciones (void)
{
	SDL_FreeSurface(fondo);
}

/*!
 * \brief genera la escena
 *
 * \return 1 en caso de error
 */
int opciones :: iniciar(class mundo *_pmundo, int _modo_video, SDL_Surface *_screen)
{
	SDL_Rect rect;	
	
	pmundo = _pmundo;
	modo_video = _modo_video;
	screen = _screen;

	fondo = SDL_DisplayFormat(screen);

	if (fondo == NULL)
	{
		printf(_("error: Can't copy screen: '%s'\n"), SDL_GetError());
		return 1;
	}

	
	pmundo->libgrafico.ima_menu->imprimir(0, fondo, &rect, 0, 0, 1);
	SDL_BlitSurface(fondo, NULL, screen, NULL);

	pmundo->fuente->myprintf (screen, SCREEN_RES_X/2, 0, NULL, NULL, false, CENTRADO, "Options");

	pmundo->fuente->myprintf (screen, 220, 150, NULL, NULL, false, NINGUNO, "Sound fx: %s", GET_VALUE(pmundo->opciones.enable_sound));
	pmundo->fuente->myprintf (screen, 280, 250, NULL, NULL, false, NINGUNO, "Music : %s", GET_VALUE(pmundo->opciones.enable_music));	

	pmundo->fuente->myprintf (screen, SCREEN_RES_X/2, 420, NULL, NULL, false, CENTRADO, _("  Touch the screen to exit"));

	SDL_Flip(screen);

	SDL_WarpMouse(1,1);

	return 0;
}

/*!
 * \brief Return the current main menu item selected with touch-screen
 * 
 * \return UNDEFINED If no menu item has been selected
 */
int opciones :: get_menu_item(int tick)
{
	int item = TOUCH_SCREEN_NO_ITEM_SELECTED;
	int x = 0,y = 0,i;

	SDL_GetMouseState(&x, &y);

	for (i=0; i<2; i++)
	{
		if (((x >= 200) && (x <= 600)) && ((y >= 100 + i*130) && (y < 230 + i*130)))
		{
			if (SDL_GetTicks() - tick_actual > 200)
			{
				item = i + 1;
				tick_actual = SDL_GetTicks();
			}
			else
			{
				SDL_WarpMouse(1,1);
				item = UNDEFINED;
			}
			break;
		}
	}

	return item;
}

/*!
 * \brief actualizacn lgica
 */
void opciones :: actualizar(int key_pressed)
{
	Uint8 * tecla;
	SDL_Rect srcrect;
	int item;

	tecla = SDL_GetKeyState(NULL);

	item = get_menu_item(SDL_GetTicks());

	srcrect.x = 250;
	srcrect.w = SCREEN_RES_X;
	srcrect.h = 80;

	if (key_pressed == 's' || item == 1)
	{
		srcrect.y = 150;

		SDL_BlitSurface (fondo, &srcrect, screen, &srcrect);
		pmundo->opciones.enable_sound = !pmundo->opciones.enable_sound;
		pmundo->fuente->myprintf (screen, 220, 150, NULL, NULL, false , NINGUNO, _("Sound fx: %s"), GET_VALUE(pmundo->opciones.enable_sound));

		if (pmundo->opciones.enable_sound)
		{
			pmundo->audio.enable_sonido();
		}
		else
		{
			pmundo->audio.disable_sonido();
		}

		SDL_Flip(screen);
		return;
	}
	else if (key_pressed == 'm' || item == 2)
	{
		srcrect.y = 250;

		SDL_BlitSurface (fondo, &srcrect, screen, &srcrect);
		pmundo->opciones.enable_music = !pmundo->opciones.enable_music;
		pmundo->fuente->myprintf (screen, 280, 250, NULL, NULL, false , NINGUNO, _("Music : %s"), GET_VALUE(pmundo->opciones.enable_music));

		if (pmundo->opciones.enable_music)
		{
			pmundo->audio.enable_musica();
			pmundo->audio.play_musica(1);
			pmundo->audio.play_dummy(0);
		}
		else
		{
			pmundo->audio.pause_musica(1);
			pmundo->audio.disable_musica();
		}

		SDL_Flip(screen);
		return;
	}

	if (tecla [SDLK_ESCAPE] || tecla [SDLK_SPACE] || tecla [SDLK_q] || ((item == TOUCH_SCREEN_NO_ITEM_SELECTED) && (key_pressed == TOUCH_SCREEN_PRESSED)))
	{
		pmundo->audio.play (4);
		pmundo->cambiar_escena(MENU);
	}
}


/*!
 * \brief imprime un texto de opciones
 */
void opciones :: imprimir(void)
{	
}

void opciones :: pausar(void)
{
}
