/*
 * Don Ceferino Hazaa - video game similary to Super Pang!
 * Copyright (c) 2004, 2005 Hugo Ruscitti
 * web site: http://www.loosersjuegos.com.ar
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Hugo Ruscitti <hugoruscitti@yahoo.com.ar>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#if 0

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL/SDL.h>


    /* Print all information about a key event */
    void PrintKeyInfo( SDL_KeyboardEvent *key ){
        /* Is it a release or a press? */
        if( key->type == SDL_KEYUP )
            printf( "Release:- " );
        else
            printf( "Press:- " );

        /* Print the hardware scancode first */
        printf( "Scancode: 0x%02X", key->keysym.scancode );
        /* Print the name of the key */
        printf( ", Name: %s", SDL_GetKeyName( key->keysym.sym ) );
        /* We want to print the unicode info, but we need to make */
        /* sure its a press event first (remember, release events */
        /* don't have unicode info                                */
        if( key->type == SDL_KEYDOWN )
        {
            printf("\nkeysym %04X %c\n",key->keysym.sym,key->keysym.sym);
            /* If the Unicode value is less than 0x80 then the    */
            /* unicode value can be used to get a printable       */
            /* representation of the key, using (char)unicode.    */
            printf(", Unicode: " );
            if( key->keysym.unicode < 0x80 && key->keysym.unicode > 0 )
            {
                printf( "%c (0x%04X)", (char)key->keysym.unicode, key->keysym.unicode);
            }
            else
            {
                printf( "? (0x%04X)", key->keysym.unicode );
            }
        }
        printf( "\n" );
    }

/* The screen surface */
SDL_Surface *screen = NULL;
SDL_Surface *fb=NULL;

//Uint32 white,black;
int black=0;
int fullscreen=0;
SDL_Rect rect;


int
main (int argc, char *argv[])
{
    char *msg;
    int done=0;
    SDL_Event event;
    int pressed = 0;

    /* Initialize SDL */
    if (SDL_Init (SDL_INIT_VIDEO) < 0){
        exit (1);
    }
    atexit (SDL_Quit);
    /* Set 640x480 16-bits video mode */
    screen = SDL_SetVideoMode (640, 480, 16, SDL_SWSURFACE | SDL_DOUBLEBUF);
    if (screen == NULL)
    {
        printf ("Couldn't set 640x480x16 video mode: %s\n",
          SDL_GetError ());
        exit (2);
    }

    SDL_EnableUNICODE(1);

    printf("Starting capturing keys...\n\n");

    /* Check for events */
    while (!done)
    {
        if (SDL_PollEvent(&event))
        {
            switch (event.type)
            {
                case SDL_KEYDOWN:
			PrintKeyInfo( &event.key );
                      switch (event.key.keysym.sym)
                      {
                        case SDLK_MODE:
                           pressed = 1;
                           break;
			case SDLK_LEFT:
                           if (pressed == 1)
		                   printf("UP KEY = -->\n\r");
                           else
		                   printf("LEFT KEY = -->\n\r");
                           break;
			case SDLK_RIGHT:
                           if (pressed == 1)
		                   printf("DOWN KEY = -->\n\r");
                           else
		                   printf("RIGHT KEY = -->\n\r");
                           break;
                        case SDLK_q:
                                done=1;
                                break;
                      }

	              if (event.key.keysym.sym == KMOD_SHIFT)
				printf("LEFT SHIFT PRESSED\n\r");
		      printf("Modifier %X\n\n", event.key.keysym.sym);
		      break;

                case SDL_KEYUP:
		        switch (event.key.keysym.sym)
		        {
                        case SDLK_MODE:
                              pressed = 0;
		              break;
		        }
			PrintKeyInfo( &event.key );
			break;
		
		case SDL_MOUSEBUTTONDOWN:
			printf("Mouse button down\n");
			break;

		case SDL_MOUSEBUTTONUP:
			printf("Mouse button up\n");
			break;

	        case SDL_QUIT:
		   done=1;
		   break;
            }
        }
    }

    exit(0);
}

#else

#include <stdio.h>
#include <stdlib.h>
#include "mundo.h"
#include "int.h"

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif


/*!
 * \brief funcion inicial de todo el programa
 */
int main (int argc, char * argv [])
{
/*
#ifdef ENABLE_NLS
	printf ("Locale: %s\n", setlocale (LC_ALL, ""));
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "");
	textdomain (GETTEXT_PACKAGE);
#else
	printf ("Locale: disabled\n");
#endif
*/
	mundo mundo;
	
	printf("\n");
	printf(" Don Ceferino - version " VERSION "\n");
	printf(" (c) - Hugo Ruscitti - www.losersjuegos.com.ar\n\n");
 	printf(" Nokia N900 porting by Luigi Cotignano\n");
 	printf(" Website: http://n900.altervista.org\n E-mail : n900.altervista@gmail.com\n");
	printf("\n");

	if (mundo.cargar_opciones())
		return 1;
	
	if (mundo.iniciar())
		return 1;
	
	mundo.correr();
	mundo.eliminar();

	printf(_("\nThanks for playing\n\n"));
	
	return 0;
}

#endif
