#include "editlistwindow.h"

EditListWindow::EditListWindow(const QStringList &list, QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_DeleteOnClose);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    QWidget *centralWidget = new QWidget();
    QVBoxLayout *lay = new QVBoxLayout(centralWidget);
    lay->setSpacing(8);
    lay->setContentsMargins(0, 0, 0, 0);
    QMaemo5EditBar *eb = new QMaemo5EditBar(tr("Choose items to delete"));
    lay->addWidget(eb);
    QPushButton *pb = new QPushButton(tr("Delete"));
    eb->addButton(pb);
    editlist = new QListWidget;
    editlist->addItems(list);
    editlist->setSelectionMode(QListWidget::MultiSelection);
    connect(pb, SIGNAL(clicked()), this, SLOT(delItems()));
    lay->addWidget(editlist);
    setCentralWidget(centralWidget);
    setWindowState(windowState() | Qt::WindowFullScreen);
}
EditListWindow::~EditListWindow()
{
}

void EditListWindow::delItems()
{
    QStringList unselectedItems;
    for (int i = 0; i < editlist->count(); ++i) {
        if (!editlist->item(i)->isSelected()){
            unselectedItems.append(editlist->item(i)->text());
        }
    }
    if (unselectedItems.size() == editlist->count()){
        return;
    }
    else {
        int reply = QMessageBox::question(this, " ", tr("Delete selected items?"), QMessageBox::Yes | QMessageBox::No, QMessageBox::No);
        if (reply == QMessageBox::Yes){
            emit returnList(unselectedItems);
            close();
        }
    }
}

