#ifndef BATTERY_H
#define BATTERY_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

//typedef struct _BatteryPlugin BatteryPlugin;
//typedef struct _BatteryPluginClass BatteryPluginClass;

#define BATTERY_TYPE_HOME_PLUGIN   (battery_plugin_get_type ())

#define BATTERY_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                        BATTERY_TYPE_HOME_PLUGIN, BatteryPlugin))

#define BATTERY_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
                        BATTERY_TYPE_HOME_PLUGIN,  BatteryPluginClass))

#define BATTERY_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                        BATTERY_TYPE_HOME_PLUGIN))
 
#define BATTERY_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                        BATTERY_TYPE_HOME_PLUGIN))

#define BATTERY_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                        BATTERY_TYPE_HOME_PLUGIN,  BatteryPluginClass))
 
typedef struct //_BatteryPlugin
{
	HDHomePluginItem parent;
	
	cairo_surface_t* image_base;
	cairo_surface_t* image_green;
	cairo_surface_t* image_yellow;
	cairo_surface_t* image_red;
	int percent;
	int design;
	gchar* percent_str;
	
	gboolean active;
	
	gint bat_pos;
	gfloat font_size;
	
	gdouble bat_size;
	
	gint timeout_handler;
} BatteryPlugin;
 
typedef struct //_BatteryPluginClass
{
	HDHomePluginItemClass parent_class;
} BatteryPluginClass;
 
GType battery_plugin_get_type(void);

G_END_DECLS

#endif

