#    This file is part of battery-eye.
#
#    battery-eye is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    battery-eye is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with battery-eye.  If not, see <http://www.gnu.org/licenses/>.

#    Copyright 2010 Jussi Holm

# Collection of some data processing functions

import beye

def getChargeInfo(dataStorage, intervalStart, intervalEnd, now):
    rawData = dataStorage.getObservations((beye.DataSourceHal.CHARGING,
                                           beye.DataSourceHal.DISCHARGING,
                                           beye.DataSourceInternal.GRAPH_BREAK),
                                           intervalStart, intervalEnd)
    if len(rawData) == 0:
        return []
    segment = []
    segments = [segment]
    for point in rawData:
        segment.append(point)
        if point[2] == beye.DataSourceInternal.GRAPH_BREAK:
            segment = []
            segments.append(segment)

    # Some serious list processing voodoo follows.

    statuses = [] #[[((charging, discharging), start, end), (...), ...], [...], ...]
    for segment in (x for x in segments if len(x) > 0):
        intervalStart = segment[0][0]
        if segment[-1][2] == beye.DataSourceInternal.GRAPH_BREAK:
            intervalEnd = dataStorage.getPreviousObservationTime(segment[-1][0])
        else:
            intervalEnd = dataStorage.getPreviousObservationTime(now)
        if intervalEnd == None or intervalStart >= intervalEnd:
            continue

        statusList = []
        lastStatus = ((False, True), intervalStart, intervalStart)
        for point in segment:
            if point[2] == beye.DataSourceHal.CHARGING:
                if point[1] != lastStatus[0][0]:
                    if point[0] > lastStatus[2]:
                        statusList.append((lastStatus[0], lastStatus[1], point[0]))
                    lastStatus = ((bool(point[1]), lastStatus[0][1]), point[0], point[0])
                else:
                    lastStatus = (lastStatus[0], lastStatus[1], point[0])
            elif point[2] == beye.DataSourceHal.DISCHARGING:
                if point[1] != lastStatus[0][1]:
                    if point[0] > lastStatus[2]:
                        statusList.append((lastStatus[0], lastStatus[1], point[0]))
                    lastStatus = ((lastStatus[0][0], bool(point[1])), point[0], point[0])
                else:
                    lastStatus = (lastStatus[0], lastStatus[1], point[0])
        statusList.append((lastStatus[0], lastStatus[1], intervalEnd))
        statuses.append([x for x in statusList if x[1] < x[2]])
    return statuses
