#ifndef READWIDGET_H
#define READWIDGET_H

#include <QWidget>
#include <QDialog>
#include "phonon/mediaobject.h"
#include "phonon/audiooutput.h"
#include "phonon/seekslider.h"
#include "phonon/volumeslider.h"

class QLabel;
class QProgressBar;
class QPushButton;
class QLineEdit;
class AudioBook;

class VolumeDialog: public QDialog
{
    Q_OBJECT

public:

    VolumeDialog(Phonon::AudioOutput* aAudioOutput, QWidget* aParent =0 );

private:

    Phonon::VolumeSlider* mVolumeSlider;
};

class ReadWidget : public QWidget
{
    Q_OBJECT
public:

    ReadWidget( QWidget* aParent = 0 );

    ~ReadWidget();

public slots:

    void readBook( AudioBook* aBook );

private slots:

    void totalTimeChanged(qint64 aTotalTime);
    
    void readProgress(qint64 aCurrentPosition );

    void stateChanged(Phonon::State aNewState, Phonon::State aOldState );

    void finished ();

    void setVolume();

    void metaDataChanged();

private:

    void setupUi();

    void closeEvent(QCloseEvent *event);

    QString timeToString(qint64 aTime);

    void createConnection();

signals:

    void bookClosed(AudioBook* book);

    void bookPaused(AudioBook* book);

private:

    AudioBook* mCurrentBook;
    int mCurrentSourceIndex;

    QLabel* mAlbumName;
    QLabel* mBookName;
    QLabel* mArtist;
    QLabel* mProgress;
    QLabel* mTotal;
    Phonon::SeekSlider* mReadProgress;

    QPushButton* mPlayButton;
    QPushButton* mPauseButton;
    QPushButton* mStopButton;
    QPushButton* mSoundButton;        

    Phonon::MediaObject* mMediaObject;
    Phonon::AudioOutput* mAudioOutput;
};

#endif // READWIDGET_H
