/*
 * Copyright (c) 2010 Kaj-Michael Lang
 * 
 * Draw given QRCode on cairo surfce.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <glib.h>
#include <cairo.h>
#include <qrencode.h>

#include "qrcode_export.h"

#define BLOCK_SIZE (12)

cairo_surface_t *
gqre_char_to_qrcode_to_cairo(const gchar *str, gint smin, gint smax, gint padding)
{
cairo_surface_t *cs;
gint ts;
QRcode *q;

q=QRcode_encodeString(str, 0, QR_ECLEVEL_M, QR_MODE_8, 1);
ts=q->width*BLOCK_SIZE;
cs=gqre_qrcode_to_cairo(q, CLAMP(ts, smin, smax), padding);
QRcode_free(q);
return cs;
}

cairo_surface_t *
gqre_qrcode_to_cairo(QRcode *q, gint isize, gdouble padding)
{
cairo_surface_t *surface;
cairo_t *cr;
gint x,y;
gdouble rs;
guchar *qb;

surface=cairo_image_surface_create(CAIRO_FORMAT_RGB24, isize, isize);
cr=cairo_create(surface);

cairo_set_antialias(cr, CAIRO_ANTIALIAS_NONE);

cairo_set_source_rgb(cr, 1.0, 1.0, 1.0);
cairo_paint(cr);

qb=q->data;
rs=(((gdouble)isize-2.0*padding)/(gdouble)q->width);

for(y=0; y<q->width; y++) {
	gdouble rx,ry;

	ry=padding+y*rs;
	for(x=0; x<q->width; x++) {
		if (*qb & 1)
			cairo_set_source_rgb(cr, 0.0, 0.0, 0.0);
		else 
			cairo_set_source_rgb(cr, 1.0, 1.0, 1.0);

		rx=padding+x*rs;

		cairo_rectangle(cr, rx, ry, rs, rs);
#if 1
		cairo_fill(cr);
#else
		cairo_fill_preserve(cr);
		cairo_stroke(cr);
#endif
		qb++;
	}
}

cairo_destroy(cr);
cairo_surface_flush(surface);
return surface;
}
