#include "config.h"

#include <glib.h>
#include <gconf/gconf-client.h>

#define GCONF_KEY_PREFIX "/apps/maemo/maemo-xhyperoid"
#define GCONF_KEY_HISCORE GCONF_KEY_PREFIX"/hiscore"

gboolean
hiscore_save(int score)
{
GConfClient *gconf_client;

gconf_client = gconf_client_get_default();
if (!gconf_client) {
	g_printerr("gconf failed\n");
	return FALSE;
}
gconf_client_set_int(gconf_client, GCONF_KEY_HISCORE, score, NULL);
gconf_client_clear_cache(gconf_client);
g_object_unref(gconf_client);
return TRUE;
}

gint
hiscore_load(void)
{
gint score=0;
GConfClient *gconf_client;

gconf_client=gconf_client_get_default();
if (!gconf_client) {
	g_printerr("gconf failed\n");
	return 0;
}

score=gconf_client_get_int(gconf_client, GCONF_KEY_HISCORE, NULL);
if (score<0) score=0;
gconf_client_clear_cache(gconf_client);
g_object_unref(gconf_client);
return score;
}
