#include "clshostlist.h"
#include "clshost.h"
#include <QString>
#include <QFile>
#include <QTextStream>
#include <QList>
#include <QDebug>
#include <QMessageBox>

clsHostList::clsHostList(QObject *parent) :
    QObject(parent)
{
}
void clsHostList::getFromFile(QString xFilename)
{
    clsHost *tg;

    sFilename=xFilename;

    QFile file(sFilename);
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QString sVersion;
        QTextStream in(&file);
        sVersion =in.readLine();

        if(sVersion=="1.0")  //Assuming first config file
        {
            while (!in.atEnd())
            {
                tg=new clsHost;
                tg->sIP=in.readLine();
                tg->sMAC=in.readLine();
                tg->iPort=in.readLine().toInt();
                tg->itcpPort=in.readLine().toInt();
                tg->iTimeOut=in.readLine().toInt();
                lstTarget.append(tg);
            }
        }
    }
    file.close();
}

void clsHostList::saveToFile()
{
    int i;
    QFile file(sFilename);
    if (file.open(QIODevice::WriteOnly | QIODevice::Truncate | QIODevice::Text))
    {



        QTextStream out(&file);

        out << "1.0\n"; // Version 1.0of the config file
        for (i=0;i< lstTarget.size();++i)
        {
            out << lstTarget.at(i)->sIP << "\n";
            out << lstTarget.at(i)->sMAC << "\n";
            out << lstTarget.at(i)->iPort << "\n";
            out << lstTarget.at(i)->itcpPort << "\n";
            out << lstTarget.at(i)->iTimeOut << "\n";
        }
    }
    else
    {
        qDebug() << "Error opening " << sFilename << file.errorString();
    }
    file.close();
}
