/**
 *  Viito -- an image dictionary for sign language
 *
 *  Copyright (C) 2010  Aki Niemi <aki.niemi@iki.fi>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VSEARCHWIDGET_H
#define VSEARCHWIDGET_H

#include <QWidget>

class QStandardItemModel;
class QModelIndex;
class QString;
class QListView;
class QLineEdit;
class VImageWidget;
class QSortFilterProxyModel;

class VSearchWidget : public QWidget
{
    Q_OBJECT

public:
    VSearchWidget(QWidget *parent=0);

    void setModel(QStandardItemModel *model);

public slots:
    void show();

private slots:
    void imageClicked(const QModelIndex &index);
    void searchEdited(const QString &text);
    void nextImage();
    void previousImage();

private:
    void setImage(const QModelIndex &index, int offset=0);

    QListView *mView;
    QLineEdit *mEdit;
    VImageWidget *mImageWidget;
    QSortFilterProxyModel *mModel;
};

#endif // VSEARCHWIDGET_H
