/* valaproperty.c generated by valac, the Vala compiler
 * generated from valaproperty.vala, do not modify */

/* valaproperty.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <valaccode.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;
typedef struct _ValaMemberPrivate ValaMemberPrivate;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;
typedef struct _ValaPropertyPrivate ValaPropertyPrivate;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
};

struct _ValaMember {
	ValaSymbol parent_instance;
	ValaMemberPrivate * priv;
};

struct _ValaMemberClass {
	ValaSymbolClass parent_class;
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaProperty {
	ValaMember parent_instance;
	ValaPropertyPrivate * priv;
};

struct _ValaPropertyClass {
	ValaMemberClass parent_class;
};

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

struct _ValaPropertyPrivate {
	ValaFormalParameter* _this_parameter;
	gboolean _notify;
	gboolean _no_accessor_method;
	gboolean _interface_only;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	ValaField* _field;
	MemberBinding _binding;
	ValaExpression* _default_expression;
	gboolean _no_array_length;
	gboolean _array_null_terminated;
	gboolean lock_used;
	ValaDataType* _data_type;
	char* _nick;
	char* _blurb;
	ValaProperty* _base_property;
	ValaProperty* _base_interface_property;
	gboolean base_properties_valid;
	ValaPropertyAccessor* _get_accessor;
	ValaPropertyAccessor* _set_accessor;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_property_parent_class = NULL;
static ValaLockableIface* vala_property_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_member_get_type (void);
GType vala_lockable_get_type (void);
GType vala_property_get_type (void);
GType vala_formal_parameter_get_type (void);
GType vala_field_get_type (void);
GType member_binding_get_type (void);
GType vala_property_accessor_get_type (void);
#define VALA_PROPERTY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY, ValaPropertyPrivate))
enum  {
	VALA_PROPERTY_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void);
ValaMember* vala_member_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_property_set_property_type (ValaProperty* self, ValaDataType* value);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
ValaProperty* vala_property_new (const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaProperty* vala_property_construct (GType object_type, const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
void vala_code_visitor_visit_member (ValaCodeVisitor* self, ValaMember* m);
void vala_code_visitor_visit_property (ValaCodeVisitor* self, ValaProperty* prop);
static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
ValaExpression* vala_property_get_default_expression (ValaProperty* self);
static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
const char* vala_symbol_get_name (ValaSymbol* self);
char* vala_property_get_upper_case_cname (ValaProperty* self);
char* vala_property_get_canonical_name (ValaProperty* self);
ValaCCodeConstant* vala_property_get_canonical_cconstant (ValaProperty* self);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_property_set_notify (ValaProperty* self, gboolean value);
void vala_property_set_no_array_length (ValaProperty* self, gboolean value);
void vala_property_set_array_null_terminated (ValaProperty* self, gboolean value);
static void vala_property_process_ccode_attribute (ValaProperty* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_property_set_no_accessor_method (ValaProperty* self, gboolean value);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
void vala_property_set_nick (ValaProperty* self, const char* value);
void vala_property_set_blurb (ValaProperty* self, const char* value);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
void vala_property_process_attributes (ValaProperty* self);
static gboolean vala_property_real_get_lock_used (ValaLockable* base);
static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used);
ValaDataType* vala_property_accessor_get_value_type (ValaPropertyAccessor* self);
gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2);
gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self);
gboolean vala_property_accessor_get_construction (ValaPropertyAccessor* self);
gboolean vala_property_equals (ValaProperty* self, ValaProperty* prop2);
static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
GType vala_typesymbol_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_class_get_type (void);
static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl);
gboolean vala_property_get_is_virtual (ValaProperty* self);
gboolean vala_property_get_overrides (ValaProperty* self);
static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl);
GType vala_interface_get_type (void);
gboolean vala_property_get_is_abstract (ValaProperty* self);
static void vala_property_find_base_properties (ValaProperty* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
ValaList* vala_class_get_base_types (ValaClass* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_class_get_is_abstract (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
GType vala_symbol_accessibility_get_type (void);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
char* vala_code_node_to_string (ValaCodeNode* self);
ValaProperty* vala_property_get_base_property (ValaProperty* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_member_get_hides (ValaMember* self);
ValaSymbol* vala_member_get_hidden_member (ValaMember* self);
void vala_report_warning (ValaSourceReference* source, const char* message);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
static gboolean vala_property_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value);
gboolean vala_property_get_notify (ValaProperty* self);
gboolean vala_property_get_no_accessor_method (ValaProperty* self);
gboolean vala_property_get_interface_only (ValaProperty* self);
void vala_property_set_interface_only (ValaProperty* self, gboolean value);
void vala_property_set_is_abstract (ValaProperty* self, gboolean value);
void vala_property_set_is_virtual (ValaProperty* self, gboolean value);
void vala_property_set_overrides (ValaProperty* self, gboolean value);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_property_set_field (ValaProperty* self, ValaField* value);
MemberBinding vala_property_get_binding (ValaProperty* self);
void vala_property_set_binding (ValaProperty* self, MemberBinding value);
ValaProperty* vala_property_get_base_interface_property (ValaProperty* self);
void vala_property_set_default_expression (ValaProperty* self, ValaExpression* value);
gboolean vala_property_get_no_array_length (ValaProperty* self);
gboolean vala_property_get_array_null_terminated (ValaProperty* self);
const char* vala_property_get_nick (ValaProperty* self);
const char* vala_property_get_blurb (ValaProperty* self);
static void vala_property_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaProperty* vala_property_construct (GType object_type, const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaProperty* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaProperty*) vala_member_construct (object_type, name, source_reference, comment);
	vala_property_set_property_type (self, property_type);
	vala_property_set_get_accessor (self, get_accessor);
	vala_property_set_set_accessor (self, set_accessor);
	return self;
}


ValaProperty* vala_property_new (const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_property_construct (VALA_TYPE_PROPERTY, name, property_type, get_accessor, set_accessor, source_reference, comment);
}


static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member (visitor, (ValaMember*) self);
	vala_code_visitor_visit_property (visitor, self);
}


static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_property_get_property_type (self), visitor);
	if (vala_property_get_get_accessor (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_property_get_get_accessor (self), visitor);
	}
	if (vala_property_get_set_accessor (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_property_get_set_accessor (self), visitor);
	}
	if (self->priv->_default_expression != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_default_expression, visitor);
	}
}


char* vala_property_get_upper_case_cname (ValaProperty* self) {
	char* result = NULL;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp3_ = g_utf8_strup (_tmp2_ = g_strdup_printf ("%s_%s", _tmp0_ = vala_symbol_get_lower_case_cname (vala_symbol_get_parent_symbol ((ValaSymbol*) self), NULL), _tmp1_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self))), -1), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
	return result;
}


ValaCCodeConstant* vala_property_get_canonical_cconstant (ValaProperty* self) {
	ValaCCodeConstant* result = NULL;
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeConstant* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp2_ = vala_ccode_constant_new (_tmp1_ = g_strdup_printf ("\"%s\"", _tmp0_ = vala_property_get_canonical_name (self))), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	return result;
}


char* vala_property_get_canonical_name (ValaProperty* self) {
	char* result = NULL;
	GString* str;
	char* i;
	g_return_val_if_fail (self != NULL, NULL);
	str = g_string_new ("");
	i = g_strdup (vala_symbol_get_name ((ValaSymbol*) self));
	while (TRUE) {
		gunichar c;
		char* _tmp0_;
		if (!(g_utf8_strlen (i, -1) > 0)) {
			break;
		}
		c = g_utf8_get_char (i);
		if (c == '_') {
			g_string_append_c (str, '-');
		} else {
			g_string_append_unichar (str, c);
		}
		i = (_tmp0_ = g_strdup (g_utf8_next_char (i)), _g_free0 (i), _tmp0_);
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
	_g_free0 (i);
	return result;
}


static void vala_property_process_ccode_attribute (ValaProperty* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "notify")) {
		vala_property_set_notify (self, vala_attribute_get_bool (a, "notify"));
	}
	if (vala_attribute_has_argument (a, "array_length")) {
		vala_property_set_no_array_length (self, !vala_attribute_get_bool (a, "array_length"));
	}
	if (vala_attribute_has_argument (a, "array_null_terminated")) {
		vala_property_set_array_null_terminated (self, vala_attribute_get_bool (a, "array_null_terminated"));
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_property_process_attributes (ValaProperty* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_property_process_ccode_attribute (self, a);
				} else {
					if (_vala_strcmp0 (vala_attribute_get_name (a), "NoAccessorMethod") == 0) {
						vala_property_set_no_accessor_method (self, TRUE);
					} else {
						if (_vala_strcmp0 (vala_attribute_get_name (a), "Description") == 0) {
							if (vala_attribute_has_argument (a, "nick")) {
								char* _tmp0_;
								vala_property_set_nick (self, _tmp0_ = vala_attribute_get_string (a, "nick"));
								_g_free0 (_tmp0_);
							}
							if (vala_attribute_has_argument (a, "blurb")) {
								char* _tmp1_;
								vala_property_set_blurb (self, _tmp1_ = vala_attribute_get_string (a, "blurb"));
								_g_free0 (_tmp1_);
							}
						} else {
							if (_vala_strcmp0 (vala_attribute_get_name (a), "Deprecated") == 0) {
								vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
							}
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_property_real_get_lock_used (ValaLockable* base) {
	ValaProperty * self;
	gboolean result = FALSE;
	self = (ValaProperty*) base;
	result = self->priv->lock_used;
	return result;
}


static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaProperty * self;
	self = (ValaProperty*) base;
	self->priv->lock_used = used;
}


gboolean vala_property_equals (ValaProperty* self, ValaProperty* prop2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prop2 != NULL, FALSE);
	if (vala_property_get_get_accessor (self) == NULL) {
		_tmp1_ = vala_property_get_get_accessor (prop2) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (vala_property_get_get_accessor (self) != NULL) {
			_tmp2_ = vala_property_get_get_accessor (prop2) == NULL;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (vala_property_get_set_accessor (self) == NULL) {
		_tmp4_ = vala_property_get_set_accessor (prop2) != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (vala_property_get_set_accessor (self) != NULL) {
			_tmp5_ = vala_property_get_set_accessor (prop2) == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	if (vala_property_get_get_accessor (self) != NULL) {
		if (!vala_data_type_equals (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop2)), vala_property_accessor_get_value_type (vala_property_get_get_accessor (self)))) {
			result = FALSE;
			return result;
		}
	}
	if (vala_property_get_set_accessor (self) != NULL) {
		if (!vala_data_type_equals (vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop2)), vala_property_accessor_get_value_type (vala_property_get_set_accessor (self)))) {
			result = FALSE;
			return result;
		}
		if (vala_property_accessor_get_writable (vala_property_get_set_accessor (self)) != vala_property_accessor_get_writable (vala_property_get_set_accessor (prop2))) {
			result = FALSE;
			return result;
		}
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (self)) != vala_property_accessor_get_construction (vala_property_get_set_accessor (prop2))) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaProperty * self;
	self = (ValaProperty*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_property_get_property_type (self) == old_type) {
		vala_property_set_property_type (self, new_type);
	}
}


static void vala_property_find_base_properties (ValaProperty* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->base_properties_valid) {
		return;
	}
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
		gboolean _tmp0_ = FALSE;
		vala_property_find_base_interface_property (self, VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)));
		if (self->priv->_is_virtual) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = self->priv->_overrides;
		}
		if (_tmp0_) {
			vala_property_find_base_class_property (self, VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)));
		}
	} else {
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
			gboolean _tmp1_ = FALSE;
			if (self->priv->_is_virtual) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = self->priv->_is_abstract;
			}
			if (_tmp1_) {
				ValaProperty* _tmp2_;
				self->priv->_base_interface_property = (_tmp2_ = _vala_code_node_ref0 (self), _vala_code_node_unref0 (self->priv->_base_interface_property), _tmp2_);
			}
		}
	}
	self->priv->base_properties_valid = TRUE;
}


static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl) {
	ValaSymbol* sym;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	sym = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) cl), vala_symbol_get_name ((ValaSymbol*) self));
	if (VALA_IS_PROPERTY (sym)) {
		ValaProperty* base_property;
		gboolean _tmp0_ = FALSE;
		base_property = _vala_code_node_ref0 (VALA_PROPERTY (sym));
		if (base_property->priv->_is_abstract) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = base_property->priv->_is_virtual;
		}
		if (_tmp0_) {
			if (!vala_property_equals (self, base_property)) {
				char* _tmp3_;
				char* _tmp2_;
				char* _tmp1_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp3_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s'.", _tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) base_property)));
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
				_vala_code_node_unref0 (base_property);
				_vala_code_node_unref0 (sym);
				return;
			}
			self->priv->_base_property = base_property;
			_vala_code_node_unref0 (base_property);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_property);
	}
	if (vala_class_get_base_class (cl) != NULL) {
		vala_property_find_base_class_property (self, vala_class_get_base_class (cl));
	}
	_vala_code_node_unref0 (sym);
}


static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _type_it;
		_type_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_class_get_base_types (cl))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaDataType* type;
			if (!vala_iterator_next (_type_it)) {
				break;
			}
			type = (ValaDataType*) vala_iterator_get (_type_it);
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
				ValaSymbol* sym;
				sym = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_data_type_get_data_type (type)), vala_symbol_get_name ((ValaSymbol*) self));
				if (VALA_IS_PROPERTY (sym)) {
					ValaProperty* base_property;
					base_property = _vala_code_node_ref0 (VALA_PROPERTY (sym));
					if (base_property->priv->_is_abstract) {
						ValaProperty* _tmp5_;
						if (!vala_property_equals (self, base_property)) {
							char* _tmp4_;
							char* _tmp3_;
							char* _tmp2_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp4_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s'.", _tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp3_ = vala_symbol_get_full_name ((ValaSymbol*) base_property)));
							_g_free0 (_tmp4_);
							_g_free0 (_tmp3_);
							_g_free0 (_tmp2_);
							_vala_code_node_unref0 (base_property);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_collection_object_unref0 (_type_it);
							return;
						}
						self->priv->_base_interface_property = (_tmp5_ = _vala_code_node_ref0 (base_property), _vala_code_node_unref0 (self->priv->_base_interface_property), _tmp5_);
						_vala_code_node_unref0 (base_property);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_collection_object_unref0 (_type_it);
						return;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_collection_object_unref0 (_type_it);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_property_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaProperty * self;
	gboolean result = FALSE;
	ValaSourceFile* old_source_file;
	ValaSymbol* old_symbol;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	self = (ValaProperty*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_property_process_attributes (self);
	if (self->priv->_is_abstract) {
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
			ValaClass* cl;
			cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)));
			if (!vala_class_get_is_abstract (cl)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Abstract properties may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			if (!VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Abstract properties may not be declared outside of classes and interfa" \
"ces");
				result = FALSE;
				return result;
			}
		}
	} else {
		if (self->priv->_is_virtual) {
			gboolean _tmp0_ = FALSE;
			if (!VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
				_tmp0_ = !VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) self));
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Virtual properties may not be declared outside of classes and interfac" \
"es");
				result = FALSE;
				return result;
			}
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
				ValaClass* cl;
				cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)));
				if (vala_class_get_is_compact (cl)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Virtual properties may not be declared in compact classes");
					result = FALSE;
					_vala_code_node_unref0 (cl);
					return result;
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			if (self->priv->_overrides) {
				if (!VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Properties may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				if (vala_symbol_get_access ((ValaSymbol*) self) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp1_ = FALSE;
					if (!VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
						_tmp1_ = !VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) self));
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Protected properties may not be declared outside of classes and interf" \
"aces");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	old_source_file = _vala_source_file_ref0 (vala_semantic_analyzer_get_current_source_file (analyzer));
	old_symbol = _vala_code_node_ref0 (vala_semantic_analyzer_get_current_symbol (analyzer));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	vala_code_node_check ((ValaCodeNode*) vala_property_get_property_type (self), analyzer);
	if (vala_property_get_get_accessor (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_property_get_get_accessor (self), analyzer);
	}
	if (vala_property_get_set_accessor (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_property_get_set_accessor (self), analyzer);
	}
	if (self->priv->_default_expression != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_default_expression, analyzer);
	}
	if (!vala_semantic_analyzer_is_type_accessible (analyzer, (ValaSymbol*) self, vala_property_get_property_type (self))) {
		char* _tmp4_;
		char* _tmp3_;
		char* _tmp2_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp4_ = g_strdup_printf ("property type `%s` is less accessible than property `%s`", _tmp2_ = vala_code_node_to_string ((ValaCodeNode*) vala_property_get_property_type (self)), _tmp3_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
		_g_free0 (_tmp4_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
	}
	if (self->priv->_overrides) {
		_tmp5_ = vala_property_get_base_property (self) == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		char* _tmp7_;
		char* _tmp6_;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp7_ = g_strdup_printf ("%s: no suitable property found to override", _tmp6_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
		_g_free0 (_tmp7_);
		_g_free0 (_tmp6_);
	}
	if (!vala_symbol_get_external_package ((ValaSymbol*) self)) {
		_tmp10_ = !self->priv->_overrides;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = !vala_member_get_hides ((ValaMember*) self);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaSymbol* _tmp11_;
		_tmp8_ = (_tmp11_ = vala_member_get_hidden_member ((ValaMember*) self)) != NULL;
		_vala_code_node_unref0 (_tmp11_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		char* _tmp15_;
		char* _tmp14_;
		ValaSymbol* _tmp13_;
		char* _tmp12_;
		vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp15_ = g_strdup_printf ("%s hides inherited property `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp14_ = vala_symbol_get_full_name (_tmp13_ = vala_member_get_hidden_member ((ValaMember*) self))));
		_g_free0 (_tmp15_);
		_g_free0 (_tmp14_);
		_vala_code_node_unref0 (_tmp13_);
		_g_free0 (_tmp12_);
	}
	if (vala_property_get_set_accessor (self) != NULL) {
		_tmp16_ = vala_property_accessor_get_construction (vala_property_get_set_accessor (self));
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		if (vala_symbol_get_access ((ValaSymbol*) self) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			char* _tmp18_;
			char* _tmp17_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp18_ = g_strdup_printf ("%s: construct properties must be public", _tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_g_free0 (_tmp18_);
			_g_free0 (_tmp17_);
		}
	}
	if (self->priv->_default_expression != NULL) {
		_tmp21_ = !vala_code_node_get_error ((ValaCodeNode*) self->priv->_default_expression);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = vala_expression_get_value_type (self->priv->_default_expression) != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		_tmp19_ = !vala_data_type_compatible (vala_expression_get_value_type (self->priv->_default_expression), vala_property_get_property_type (self));
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		char* _tmp24_;
		char* _tmp23_;
		char* _tmp22_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self->priv->_default_expression), _tmp24_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp22_ = vala_code_node_to_string ((ValaCodeNode*) vala_property_get_property_type (self)), _tmp23_ = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (self->priv->_default_expression))));
		_g_free0 (_tmp24_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp22_);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	_vala_source_file_unref0 (old_source_file);
	_vala_code_node_unref0 (old_symbol);
	return result;
}


ValaDataType* vala_property_get_property_type (ValaProperty* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_type;
	return result;
}


void vala_property_set_property_type (ValaProperty* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_data_type = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_data_type), _tmp0_);
	if (value != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_data_type, (ValaCodeNode*) self);
	}
}


ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_get_accessor;
	return result;
}


void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_get_accessor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_get_accessor), _tmp0_);
	if (value != NULL) {
		vala_symbol_set_owner ((ValaSymbol*) value, vala_symbol_get_scope ((ValaSymbol*) self));
	}
}


ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_set_accessor;
	return result;
}


void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_set_accessor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_set_accessor), _tmp0_);
	if (value != NULL) {
		vala_symbol_set_owner ((ValaSymbol*) value, vala_symbol_get_scope ((ValaSymbol*) self));
	}
}


ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self) {
	ValaFormalParameter* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_this_parameter;
	return result;
}


void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value) {
	ValaFormalParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_this_parameter = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_this_parameter), _tmp0_);
}


gboolean vala_property_get_notify (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_notify;
	return result;
}


void vala_property_set_notify (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_notify = value;
}


gboolean vala_property_get_no_accessor_method (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_accessor_method;
	return result;
}


void vala_property_set_no_accessor_method (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_accessor_method = value;
}


gboolean vala_property_get_interface_only (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_interface_only;
	return result;
}


void vala_property_set_interface_only (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_interface_only = value;
}


gboolean vala_property_get_is_abstract (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}


void vala_property_set_is_abstract (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean vala_property_get_is_virtual (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}


void vala_property_set_is_virtual (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean vala_property_get_overrides (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}


void vala_property_set_overrides (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


ValaField* vala_property_get_field (ValaProperty* self) {
	ValaField* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_field;
	return result;
}


void vala_property_set_field (ValaProperty* self, ValaField* value) {
	ValaField* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_field = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_field), _tmp0_);
}


MemberBinding vala_property_get_binding (ValaProperty* self) {
	MemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}


void vala_property_set_binding (ValaProperty* self, MemberBinding value) {
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


ValaProperty* vala_property_get_base_property (ValaProperty* self) {
	ValaProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	result = self->priv->_base_property;
	return result;
}


ValaProperty* vala_property_get_base_interface_property (ValaProperty* self) {
	ValaProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	result = self->priv->_base_interface_property;
	return result;
}


ValaExpression* vala_property_get_default_expression (ValaProperty* self) {
	ValaExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_expression;
	return result;
}


void vala_property_set_default_expression (ValaProperty* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_default_expression = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_default_expression), _tmp0_);
}


gboolean vala_property_get_no_array_length (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_array_length;
	return result;
}


void vala_property_set_no_array_length (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_array_length = value;
}


gboolean vala_property_get_array_null_terminated (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_array_null_terminated;
	return result;
}


void vala_property_set_array_null_terminated (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_array_null_terminated = value;
}


const char* vala_property_get_nick (ValaProperty* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_nick == NULL) {
		char* _tmp0_;
		self->priv->_nick = (_tmp0_ = vala_property_get_canonical_name (self), _g_free0 (self->priv->_nick), _tmp0_);
	}
	result = self->priv->_nick;
	return result;
}


void vala_property_set_nick (ValaProperty* self, const char* value) {
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_nick = (_tmp1_ = g_strdup (value), _g_free0 (self->priv->_nick), _tmp1_);
}


const char* vala_property_get_blurb (ValaProperty* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_blurb == NULL) {
		char* _tmp0_;
		self->priv->_blurb = (_tmp0_ = vala_property_get_canonical_name (self), _g_free0 (self->priv->_blurb), _tmp0_);
	}
	result = self->priv->_blurb;
	return result;
}


void vala_property_set_blurb (ValaProperty* self, const char* value) {
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_blurb = (_tmp1_ = g_strdup (value), _g_free0 (self->priv->_blurb), _tmp1_);
}


static void vala_property_class_init (ValaPropertyClass * klass) {
	vala_property_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_property_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_property_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_property_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_property_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_property_real_check;
}


static void vala_property_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_property_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_property_real_get_lock_used;
	iface->set_lock_used = vala_property_real_set_lock_used;
}


static void vala_property_instance_init (ValaProperty * self) {
	self->priv = VALA_PROPERTY_GET_PRIVATE (self);
	self->priv->_notify = TRUE;
	self->priv->_binding = MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void vala_property_finalize (ValaCodeNode* obj) {
	ValaProperty * self;
	self = VALA_PROPERTY (obj);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_field);
	_vala_code_node_unref0 (self->priv->_default_expression);
	_vala_code_node_unref0 (self->priv->_data_type);
	_g_free0 (self->priv->_nick);
	_g_free0 (self->priv->_blurb);
	_vala_code_node_unref0 (self->priv->_base_interface_property);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	VALA_CODE_NODE_CLASS (vala_property_parent_class)->finalize (obj);
}


GType vala_property_get_type (void) {
	static volatile gsize vala_property_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProperty), 0, (GInstanceInitFunc) vala_property_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_property_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_property_type_id;
		vala_property_type_id = g_type_register_static (VALA_TYPE_MEMBER, "ValaProperty", &g_define_type_info, 0);
		g_type_add_interface_static (vala_property_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_property_type_id__volatile, vala_property_type_id);
	}
	return vala_property_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




