//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef TORRENTITEM_H
#define TORRENTITEM_H

#include <QtGui/QFrame>
#include <QMouseEvent>
#include <QTime>
#include "torrentdata.h"
#include "btconnection.h"

namespace Ui {
	class TorrentItem;
}

class TorrentItem : public QFrame {
	Q_OBJECT

public:
	TorrentItem(TorrentData data, QWidget *parent = 0);
	~TorrentItem();
	TorrentData Data(){return data;}
	void setData(TorrentData d){data = d; Reload();}

signals:
        void clicked(TorrentData data);


protected:
	void changeEvent(QEvent *e);
        void mousePressEvent(QMouseEvent* e){ //on mouse down
            mouseLoc = e->globalPos();
        }
        void mouseReleaseEvent(QMouseEvent* e){ //on mouse up
            int mag2 =
                (mouseLoc.x() - e->globalPos().x())*(mouseLoc.x() - e->globalPos().x()) +
                (mouseLoc.y() - e->globalPos().y())*(mouseLoc.y() - e->globalPos().y());

            if(mag2 < 1000*1000)
                clicked(data);
        }

private:
	Ui::TorrentItem *ui;
        TorrentData data;
	BtConnection *connection;
        QPointF mouseLoc;

	void Reload();
};

#endif // TORRENTITEM_H
