//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QTimer>
#include <QSettings>
#include "btconnection.h"
#include "torrentdata.h"
#include "torrentitem.h"

namespace Ui{
	class MainWindow;
}

class MainWindow : public QMainWindow{
	Q_OBJECT

public:
	MainWindow(QWidget *parent = 0);
	~MainWindow();
	QSettings* Settings;
	BtConnection *connection;

	//Settings
	QString Filter(){return Settings->value("Filter", "All").toString();}
	void setFilter(QString value){Settings->setValue("Filter", value);}
	bool FilterIsState(){return Settings->value("FilterIsState", true).toBool();}
	void setFilterIsState(bool value){Settings->setValue("FilterIsState", value);}
	TSortMode SortMode(){return (TSortMode) Settings->value("SortMode", TSM_Status).toInt();}
	void setSortMode(TSortMode mode){Settings->setValue("SortMode", mode);}
	int RefreshRate(){return Settings->value("RefreshRate", 1000).toInt();}
	void setRefreshRate(int value){
		Settings->setValue("RefreshRate", value);
		UpdateTimer->setInterval(value);
	}
	QString Hostname(){return Settings->value("Hostname", "192.168.1.1").toString();}
	void setHostname(QString value){
		Settings->setValue("Hostname", value);
	}
	int PortNo(){return Settings->value("PortNo", 80).toInt();}
	void setPortNo(int value){
		Settings->setValue("PortNo", value);
	}
	QString Username(){return Settings->value("Username", "user").toString();}
	void setUsername(QString value){
		Settings->setValue("Username", value);
	}
	QString Password(){return Settings->value("Password", "").toString();}
	void setPassword(QString value){
		Settings->setValue("Password", value);
	}
	bool AutoUpdatesEnabled(){return Settings->value("AutoUpdatesEnabled", false).toBool();}
	void setAutoUpdatesEnabled(bool value){
		Settings->setValue("AutoUpdatesEnabled", value);
		UpdateTimer->stop();
		if(value) UpdateTimer->start(RefreshRate());
	}

private:
	Ui::MainWindow *ui;
	QTimer* UpdateTimer;
	QList<TorrentItem*> Torrents;
	QList<TorrentData> Filter(QList<TorrentData>);
	bool SuppressMessages;

private slots:
	void UpdateView();
	void OnError(QString);
	void ShowFilterDialog();
	void UpdateFilter(QString, bool, TSortMode);
	void ShowSettingsDialog();
	void ShowTorrentDialog(TorrentData);
	void ShowAddTorrentDialog();
	void ShowAbout();
};

#endif // MAINWINDOW_H
