unit conicconnectionevent;

{$mode objfpc}{$H+}
{$packrecords C}

interface

uses
  Classes, SysUtils, glib2;

type
{**
 * ConIcConnectionEvent object. The contents of the object is private, to
 * access the object use the functions provided by conicconnectionevent.h.
 *}
  TConIcConnectionEvent = record
  end;
  PConIcConnectionEvent = ^TConIcConnectionEvent;

  TConIcConnectionEventClass = record
  end;
  PConIcConnectionEventClass = ^TConIcConnectionEventClass;

  {**
   * IAP connection statuses.
   *
   * @note More status types might be added in the future.
   *}
  TConIcConnectionStatus = (
  	//** The IAP was connected */
  	CON_IC_STATUS_CONNECTED,
  	//** The IAP was disconnected */
  	CON_IC_STATUS_DISCONNECTED,
  	//** The IAP is disconnecting */
  	CON_IC_STATUS_DISCONNECTING,
  	//** The IAP has a network address, but is not yet fully connected */
  	CON_IC_STATUS_NETWORK_UP);

  {**
   * Error codes for connection events. Only set in DISCONNECTED events,
   * otherwise set to CON_IC_CONNECTION_ERROR_NONE.
   *
   * @note More error types might be added in the future.
   *}
  TConIcConnectionError = (
  	{ No errors. }
  	CON_IC_CONNECTION_ERROR_NONE,
  	{ Requested IAP was invalid (for example not found or incomplete
  	    settings). }
  	CON_IC_CONNECTION_ERROR_INVALID_IAP,
  	{ Connections establishment failed for unknown reason. }
  	CON_IC_CONNECTION_ERROR_CONNECTION_FAILED,
  	{ Connections establishment failed because of user
  	    cancellation. }
  	CON_IC_CONNECTION_ERROR_USER_CANCELED);



function con_ic_connection_event_get_type:GType; cdecl; external 'libconic.so';

{**
 * Get status from the event.
 *
 * @param event OssIcConnectionEvent object
 * @returns status
 *}
function con_ic_connection_event_get_status(event : PConIcConnectionEvent): TConIcConnectionStatus; cdecl; external 'libconic.so';

{**
 * Get error from the event.
 *
 * @param event OssIcConnectionEvent object
 * @returns error
 *}
function con_ic_connection_event_get_error(event : PConIcConnectionEvent): TConIcConnectionError; cdecl; external 'libconic.so';

implementation

end.

