#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QTextBrowser>
#include <QWebView>
#include <QMenu>
#include <QAction>
#include <QtGui>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5InformationBox>
#include <QMessageBox>
#include <QStandardItem>
#include <QStandardItemModel>
#include <QtMaemo5>
#include <QScrollArea>
#include <QGesture>

#include "mainwindow.h"
#include "tubeapi.h"

MainWindow::MainWindow()
    : QMainWindow()
{
	setAttribute(Qt::WA_Maemo5StackedWindow);

	route = new QAction(tr("&ROUTE"), this);
	route->setShortcut(tr("Ctrl+R"));
	route->setStatusTip(tr("Displays the London Tube Routing Widget"));
	connect(route, SIGNAL(triggered()), this, SLOT(showRouteWindow()));

	showmap = new QAction(tr("&SHOW MAP"), this);
	showmap->setShortcut(tr("Ctrl+M"));
	showmap->setStatusTip(tr("Displays the London Tube Map"));
	connect(showmap, SIGNAL(triggered()), this , SLOT(showMapWindow()));

	aboutAct = new QAction(tr("&ABOUT"), this);
	aboutAct->setShortcut(tr("Ctrl+A"));
	aboutAct->setStatusTip(tr("About"));
	connect(aboutAct, SIGNAL(triggered()), this , SLOT(showAbout()));

	donateAct = new QAction(tr("&DONATE"), this);
	donateAct->setShortcut(tr("Ctrl+D"));
	donateAct->setStatusTip(tr("Donate"));
	connect(donateAct, SIGNAL(triggered()), this , SLOT(showDonate()));

	exitAct = new QAction(tr("&EXIT"), this);
	exitAct->setShortcut(tr("Ctrl+E"));
	exitAct->setStatusTip(tr("About"));
	connect(exitAct, SIGNAL(triggered()), this , SLOT(close()));

	menu = menuBar()->addMenu(tr(""));
	menu->addAction(route);
    menu->addAction(showmap);
    menu->addAction(aboutAct);
    menu->addAction(donateAct);
    menu->addAction(exitAct);

	tubeListWidget = new QWidget( this );
	mainlayout = new QBoxLayout( QBoxLayout::LeftToRight );	
	sublayout1 = new QVBoxLayout;	
	sublayout2 = new QVBoxLayout;	
	tubeListWidget->grabGesture(Qt::PinchGesture);

	circle = new QPushButton ( "CIRCLE", this );
	circle->setStyleSheet("QPushButton { color: yellow; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	district = new QPushButton ( "DISTRICT", this );
	district->setStyleSheet("QPushButton { color: green; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	central = new QPushButton ( "CENTRAL", this );
	central->setStyleSheet("QPushButton { color: red; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	northern = new QPushButton ( "NORTHERN", this );
	northern->setStyleSheet("QPushButton { color: black; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	piccadilly = new QPushButton ( "PICCADILLY", this );
	piccadilly->setStyleSheet("QPushButton { color: darkBlue; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	hmcity = new QPushButton ( "HAMMERSMITHCITY", this );
	hmcity->setStyleSheet("QPushButton { color: magenta; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	jubilee = new QPushButton ( "JUBILEE", this );
	jubilee->setStyleSheet("QPushButton { color: darkGrey; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	metropolitan = new QPushButton ( "METROPOLITAN", this );
	metropolitan->setStyleSheet("QPushButton { color: darkMagenta; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	bakerloo = new QPushButton ( "BAKERLOO", this );
	bakerloo->setStyleSheet("QPushButton { color: darkred; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	waterloocity = new QPushButton ( "WATERLOOCITY", this );
	waterloocity->setStyleSheet("QPushButton { color: cyan; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	victoria = new QPushButton ( "VICTORIA", this );
	victoria->setStyleSheet("QPushButton { color: blue; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	all = new QPushButton ( "ALL", this );
	all->setStyleSheet("QPushButton { color: white; font: bold 28px; border: 3px solid grey; height: 60px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 100), stop:1 rgba(0, 0, 0, 100)); min-width: 180px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");

	sublayout1->addWidget( circle );
	sublayout1->addWidget( district );
	sublayout1->addWidget( central );
	sublayout1->addWidget( northern );
	sublayout1->addWidget( piccadilly );
	sublayout1->addWidget( hmcity );
	sublayout2->addWidget( jubilee );
	sublayout2->addWidget( metropolitan );
	sublayout2->addWidget( victoria );
	sublayout2->addWidget( waterloocity );
	sublayout2->addWidget( bakerloo );
	sublayout2->addWidget( all );

	mainlayout->addLayout(sublayout1);
	mainlayout->addLayout(sublayout2);
	tubeListWidget->setLayout(mainlayout);

	setCentralWidget(tubeListWidget);

	connect( all, SIGNAL(clicked()), SLOT(goAll()) );
	connect( circle, SIGNAL(clicked()), SLOT(goCircle()) );
	connect( victoria, SIGNAL(clicked()), SLOT(goVictoria()) );
	connect( jubilee, SIGNAL(clicked()), SLOT(goJubilee()) );
	connect( bakerloo, SIGNAL(clicked()), SLOT(goBakerloo()) );
	connect( hmcity, SIGNAL(clicked()), SLOT(goHammersmithCity()) );
	connect( metropolitan, SIGNAL(clicked()), SLOT(goMetropolitan()) );
	connect( piccadilly, SIGNAL(clicked()), SLOT(goPiccadilly()) );
	connect( waterloocity, SIGNAL(clicked()), SLOT(goWaterlooCity()) );
	connect( northern, SIGNAL(clicked()), SLOT(goNorthern()) );
	connect( district, SIGNAL(clicked()), SLOT(goDistrict()) );
	connect( central, SIGNAL(clicked()), SLOT(goCentral()) );

	tubeapi1 = new TubeApi(this, STATUS_FUNC);
	tubeapi2 = new TubeApi(this, ROUTING_FUNC);
	// connect the formatStatusWindowData method of the mainwindow to the tubeapi finished
	connect( tubeapi1, SIGNAL(finished(bool)), SLOT(formatStatusWindowData(bool)) );
	// connect the showRouteData method of the mainwindow to the tubeapi finished
	connect(tubeapi2, SIGNAL(finished(bool)), SLOT(formatRouteWindowData(bool)) );
}


MainWindow::~MainWindow()
{
}

void MainWindow::showStatusWindow()
{
}


void MainWindow::showRouteWindow()
{
	QStringList stationList;
	stationList << "Acton Town" << "Addington Village" << "Addiscombe" << "Aldgate" << "Aldgate East" << "All Saints" << "Alperton" << "Amersham" << "Ampere Way" << "Angel" << "Archway" << "Arena" << "Arnos Grove" << "Arsenal" << "Avenue Road" << "Baker Street" << "Balham" << "Bank" << "Barbican" << "Barking" << "Barkingside" << "Barons Court" << "Bayswater" << "Beckenham Junction" << "Beckenham Road" << "Beckton" << "Beckton Park" << "Becontree" << "Beddington Lane" << "Belgrave Walk" << "Belsize Park" << "Bermondsey" << "Bethnal Green" << "Birkbeck" << "Blackfriars" << "Blackhorse Lane" << "Blackhorse Road" << "Blackwall" << "Bond Street" << "Borough" << "Boston Manor" << "Bounds Green" << "Bow Church" << "Bow Road" << "Brent Cross" << "Brixton" << "Bromley-by-Bow" << "Buckhurst Hill" << "Burnt Oak" << "Caledonian Road" << "Camden Town" << "Canada Water" << "Canary Wharf" << "Canning Town" << "Cannon Street" << "Canons Park" << "Chalfont & Latimer" << "Chalk Farm" << "Chancery Lane" << "Charing Cross" << "Chesham" << "Chigwell" << "Chiswick Park" << "Chorleywood" << "Church Street" << "Clapham Common" << "Clapham North" << "Clapham South" << "Cockfosters" << "Colindale" << "Colliers Wood" << "Coombe Lane" << "Covent Garden" << "Crossharbour & London Arena" << "Croxley" << "Custom House" << "Cutty Sark for Maritime Greenwich" << "Cyprus" << "Dagenham East" << "Dagenham Heathway" << "Debden" << "Deptford Bridge" << "Devons Row" << "Dollis Hill" << "Dundonald Road" << "Ealing Broadway" << "Ealing Common" << "Earl's Court" << "East Acton" << "East Croydon" << "East Finchley" << "East Ham" << "East India" << "East Putney" << "Eastcote" << "Edgware" << "Edgware Road (Bakerloo)" << "Edgware Road (Circle/District/H&C)" << "Elephant & Castle" << "Elm Park" << "Elmers End" << "Elverson Road" << "Embankment" << "Epping" << "Euston" << "Euston Square" << "Fairlop" << "Farringdon" << "Fieldway" << "Finchley Central" << "Finchley Road" << "Finsbury Park" << "Fulham Broadway" << "Gallions Reach" << "Gants Hill" << "George Street" << "Gloucester Road" << "Golders Green" << "Goldhawk Road" << "Goodge Street" << "Grange Hill" << "Gravel" << "Great Portland Street" << "Green Park" << "Greenford" << "Greenwich" << "Gunnersbury" << "Hainault" << "Hammersmith (District)" << "Hammersmith (Met.)" << "Hampstead" << "Hanger Lane" << "Harlesden" << "Harrington Road" << "Harrow & Wealdstone" << "Harrow-on-the-Hill" << "Hatton Cross" << "Heathrow Terminal 4" << "Heathrow Terminal 5" << "Heathrow Terminals 1 2 3" << "Hendon Central" << "Heron Quays" << "High Barnet" << "High Street Kensington" << "Highbury & Islington" << "Highgate" << "Hillingdon" << "Holborn" << "Holland Park" << "Holloway Road" << "Hornchurch" << "Hounslow Central" << "Hounslow East" << "Hounslow West" << "Hyde Park Corner" << "Ickenham" << "Island Gardens" << "Kennington" << "Kensal Green" << "Kensington (Olympia)" << "Kentish Town" << "Kenton" << "Kew Gardens" << "Kilburn" << "Kilburn Park" << "King George V" << "King Henry's Drive" << "King's Cross St. Pancras" << "Kingsbury" << "Knightsbridge" << "Ladbroke Grove" << "Lambeth North" << "Lancaster Gate" << "Latimer Road" << "Lebanon Road" << "Leicester Square" << "Lewisham" << "Leyton" << "Leytonstone" << "Limehouse" << "Liverpool Street" << "Lloyd Park" << "London Bridge" << "London City Airport" << "Loughton" << "Maida Vale" << "Manor House" << "Mansion House" << "Marble Arch" << "Marylebone" << "Merton Park" << "Mile End" << "Mill Hill East" << "Mitcham" << "Mitcham Junction" << "Monument" << "Moor Park" << "Moorgate" << "Morden" << "Morden Road" << "Mornington Crescent" << "Mudchute" << "Neasden" << "New Addington" << "New Cross" << "New Cross Gate" << "Newbury Park" << "North Acton" << "North Ealing" << "North Greenwich" << "North Harrow" << "North Wembley" << "Northfields" << "Northolt" << "Northwick Park" << "Northwood" << "Northwood Hills" << "Notting Hill Gate" << "Oakwood" << "Old Street" << "Osterley" << "Oval" << "Oxford Circus" << "Paddington" << "Park Royal" << "Parsons Green" << "Perivale" << "Phipps Bridge" << "Piccadilly Circus" << "Pimlico" << "Pinner" << "Plaistow" << "Pontoon Dock" << "Poplar" << "Preston Road" << "Prince Regent" << "Pudding Mill Lane" << "Putney Bridge" << "Queen's Park" << "Queensbury" << "Queensway" << "Ravenscourt Park" << "Rayners Lane" << "Redbridge" << "Reeves Corner" << "Regent's Park" << "Richmond" << "Rickmansworth" << "Roding Valley" << "Rotherhithe" << "Royal Albert" << "Royal Oak" << "Royal Victoria" << "Ruislip" << "Ruislip Gardens" << "Ruislip Manor" << "Russell Square" << "Sandilands" << "Seven Sisters" << "Shadwell" << "Shepherd's Bush (Central)" << "Shepherd's Bush (Hammersmith)" << "Shepherd's Bush Market" << "Shoreditch" << "Sloane Square" << "Snaresbrook" << "South Ealing" << "South Harrow" << "South Kensington" << "South Kenton" << "South Quay" << "South Ruislip" << "South Wimbledon" << "South Woodford" << "Southfields" << "Southgate" << "Southwark" << "St. James's Park" << "St. John's Wood" << "St. Paul's" << "Stamford Brook" << "Stanmore" << "Stepney Green" << "Stockwell" << "Stonebridge Park" << "Stratford" << "Sudbury Hill" << "Sudbury Town" << "Surrey Quays" << "Swiss Cottage" << "Temple" << "Therapia Lane" << "Theydon Bois" << "Tooting Bec" << "Tooting Broadway" << "Tottenham Court Road" << "Tottenham Hale" << "Totteridge & Whetstone" << "Tower Gateway" << "Tower Hill" << "Tufnell Park" << "Turnham Green" << "Turnpike Lane" << "Upminster" << "Upminster Bridge" << "Upney" << "Upton Park" << "Uxbridge" << "Vauxhall" << "Victoria" << "Waddon Marsh" << "Walthamstow Central" << "Wandle Park" << "Wanstead" << "Wapping" << "Warren Street" << "Warwick Avenue" << "Waterloo" << "Watford" << "Wellesley Road" << "Wembley Central" << "Wembley Park" << "West Acton" << "West Brompton" << "West Croydon" << "West Finchley" << "West Ham" << "West Hampstead" << "West Harrow" << "West India Quay" << "West Kensington" << "West Ruislip" << "West Silvertown" << "Westbourne Park" << "Westferry" << "Westminster" << "White City" << "Whitechapel" << "Willesden Green" << "Willesden Junction" << "Wimbledon" << "Wimbledon Park" << "Wood Green" << "Woodford" << "Woodside" << "Woodside Park";

	_routingWindow = new QMainWindow ( this );
	_routingWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
	_routingWindow->setAttribute(Qt::WA_DeleteOnClose);

	QWidget* routeWidget = new QWidget(this);
	QVBoxLayout *layout = new QVBoxLayout(routeWidget);

	QStandardItemModel *stationListModel = new QStandardItemModel(0, 1);

	foreach(QString station, stationList)

	{
		QStandardItem *item = new QStandardItem(station);
		item->setTextAlignment(Qt::AlignCenter); // the Maemo 5 design spec recommends this.
		item->setEditable(false); // prevent editing of the item
		stationListModel->appendRow(item);
	}

	QPushButton *routeMe = new QPushButton("Route Me");
	routeMe->setStyleSheet("QPushButton { border: 2px solid #8f8f91; height: 50px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 120), stop:1 rgba(0, 0, 0, 120)); min-width: 600; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	//routeMe->setStyleSheet("QPushButton { color: darkblue; font: bold 50px; }");

	// buttons used in the routing window, their values are needed globally
	fromButton = new QMaemo5ValueButton("From : ");
	toButton = new QMaemo5ValueButton("To   : ");
	//viaButton = new QMaemo5ValueButton("VIA   : ");
	fromButton->setAttribute(Qt::WA_DeleteOnClose);
	toButton->setAttribute(Qt::WA_DeleteOnClose);

	fromButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
	toButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
	//viaButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);

	QMaemo5ListPickSelector *fromSelector = new QMaemo5ListPickSelector;
	QMaemo5ListPickSelector *toSelector = new QMaemo5ListPickSelector;
	//QMaemo5ListPickSelector *viaSelector = new QMaemo5ListPickSelector;
	fromSelector->setModel(stationListModel);
	toSelector->setModel(stationListModel);
	//viaSelector->setModel(stationListModel);
	// not setting the current index means that the value is empty.
	fromButton->setPickSelector(fromSelector);
	toButton->setPickSelector(toSelector);
	//viaButton->setPickSelector(viaSelector);

	connect(routeMe, SIGNAL(clicked()), SLOT(getRouteData()));

	layout->addWidget(fromButton);
	layout->addWidget(toButton);
	//layout->addWidget(viaButton);
	layout->addWidget(routeMe);

	_routingWindow->setCentralWidget(routeWidget);
	_routingWindow->show();
}


void MainWindow::zoomInMap()
{
	_scrollForMapPage->setWidgetResizable(false);

	imageLabel->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
	imageLabel->setScaledContents(true);
	double scaleFactor = 2.0;
	imageLabel->resize(scaleFactor * imageLabel->pixmap()->size());

	_scrollForMapPage->horizontalScrollBar()->setValue(int(scaleFactor * _scrollForMapPage->horizontalScrollBar()->value() + ((scaleFactor - 1) * _scrollForMapPage->horizontalScrollBar()->pageStep()/2)));
	_scrollForMapPage->verticalScrollBar()->setValue(int(scaleFactor * _scrollForMapPage->verticalScrollBar()->value() + ((scaleFactor - 1) * _scrollForMapPage->verticalScrollBar()->pageStep()/2)));
		
}

void MainWindow::zoomOutMap()
{
	imageLabel->resize(1 * imageLabel->pixmap()->size());
}

void MainWindow::showMapWindow()
{
	QWidget *mapWidget = new QWidget;

	imageLabel = new QLabel;
	QImage image("/opt/travelapp/data/londontubemap.gif");
	imageLabel->setPixmap(QPixmap::fromImage(image));

	_mapWindow = new QMainWindow ( this );
	_mapWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
	_mapWindow->setAttribute(Qt::WA_DeleteOnClose);

	QHBoxLayout *layout = new QHBoxLayout;

	_scrollForMapPage = new QScrollArea;
	_scrollForMapPage->setWidget(imageLabel);
	_scrollForMapPage->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	_scrollForMapPage->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

	QPushButton* zoominButton = new QPushButton("+");
	QPushButton* zoomoutButton = new QPushButton("-");
	zoominButton->setMaximumSize(50, 50);
	zoomoutButton->setMaximumSize(50, 50);
	zoominButton->setStyleSheet("QPushButton { border: 2px solid #8f8f91; height: 50px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 120), stop:1 rgba(0, 0, 0, 120)); min-width: 50px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");
	zoomoutButton->setStyleSheet("QPushButton { border: 2px solid #8f8f91; height: 50px; border-radius: 15px; background-color: qlineargradient(spread:reflect, x1:0, y1:0, x2:0, y2:0.982955, stop:0.180617 rgba(255, 255, 255, 120), stop:1 rgba(0, 0, 0, 120)); min-width: 50px; } QPushButton:pressed { background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #dadbde, stop: 1 #f6f7fa) }");

	connect(zoominButton, SIGNAL(clicked()), this, SLOT(zoomInMap()));
	connect(zoomoutButton, SIGNAL(clicked()), this, SLOT(zoomOutMap()));

	QHBoxLayout *hlayout = new QHBoxLayout;
	hlayout->addWidget(_scrollForMapPage);

	QVBoxLayout *vlayout = new QVBoxLayout;
	vlayout->addWidget(zoominButton);
	vlayout->addWidget(zoomoutButton);

	layout->addLayout(hlayout);
	layout->addLayout(vlayout);

	mapWidget->setLayout(layout);

	_mapWindow->setCentralWidget(mapWidget);
	_mapWindow->show();
}

void MainWindow::showAbout()
{
		QString line1 = "The TravelApp can (at the moment) be used for the following:\n\n";
		QString line2 = "* To Check the status of individual/All London tubes.\n";
		QString line3 = "* To get detailed route information between London tube stations.\n";
		QString line4 = "* To see a detailed tube map\n\n";
		QString line5 = "Its a generic design so its possible to include other city/mode transport if they have websites that provide api's";

		QString line = line1 + line2 + line3 + line4 + line5;

		QMessageBox::about(this, "TRAVELAPP v0.1", line);
}

void MainWindow::showDonate()
{
	QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=rkmaemo@gmx.com&lc=GB&item_name=TravelApp Maemo&currency_code=GBP&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted"));
}

void MainWindow::goAll()
{
	getStatusData("all"); 
}

void MainWindow::goCircle()
{
	getStatusData("circle"); 
}

void MainWindow::goDistrict()
{
	getStatusData("district"); 
}

void MainWindow::goCentral()
{
	getStatusData("central"); 
}

void MainWindow::goPiccadilly()
{
	getStatusData("piccadilly"); 
}

void MainWindow::goVictoria()
{
	getStatusData("victoria"); 
}

void MainWindow::goBakerloo()
{
	getStatusData("bakerloo"); 
}

void MainWindow::goJubilee()
{
	getStatusData("jubilee"); 
}

void MainWindow::goNorthern()
{
	getStatusData("northern"); 
}

void MainWindow::goWaterlooCity()
{
	getStatusData("waterloocity"); 
}

void MainWindow::goMetropolitan()
{
	getStatusData("metropolitan"); 
}

void MainWindow::goHammersmithCity()
{
	getStatusData("hammersmithcity"); 
}

void MainWindow::getStatusData(const QString& tubeline)
{

	QUrl url("http://api.tubeupdates.com/?method=get.status");
	url.addQueryItem( QString("lines"), tubeline );
	url.addQueryItem( QString("format"), QString("xml") );

	tubeapi1->setUrl(url);
    tubeapi1->search(); 
}

void MainWindow::formatStatusWindowData( bool ok )
{
	if(!ok)
		QMaemo5InformationBox::information(this, "There was a <b>Network Error</b>, check if its your Internet connection" , QMaemo5InformationBox::DefaultTimeout);

	int count = 0;

	_dataWindow = new QMainWindow ( this );
	_dataWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
	_dataWindow->setAttribute(Qt::WA_DeleteOnClose);

	_scrollForStatusDataPage = new QTextBrowser( _dataWindow );

	_scrollForStatusDataPage->clear();

	foreach(QString s, tubeapi1->results())
	{
		count++;
		if ( (count % 2) ) 
		{
			_scrollForStatusDataPage->setTextColor(QColor(Qt::blue));
		}
		else
		{
			_scrollForStatusDataPage->setTextColor(QColor(Qt::black));
		}

		_scrollForStatusDataPage->append(s);
	}
	_scrollForStatusDataPage->moveCursor(QTextCursor::Start);
	_dataWindow->setCentralWidget(_scrollForStatusDataPage);
    _dataWindow->show();
}

void MainWindow::getRouteData()
{
	// get the from and to values from the selector buttons
	// so the routing function can use them
	QString from = fromButton->valueText();
	QString to = toButton->valueText();
	//QString via = viaButton->valueText();

	//QString urlStr = QString("http://www.tubeplanner.com/cgi-bin/planner/route.pl?start=%1&end=%2&via=%3&search_type=fastest&submit.x=66&submit.y=4&submit=Find+Route&search_type2=fastest").arg(from).arg(to).arg(via);
	QString urlStr = QString("http://www.tubeplanner.com/search/result?from=%1&to=%2&go=Go").arg(from).arg(to);
	QUrl url(urlStr);
	tubeapi2->setUrl(url);
	
	tubeapi2->search();

}

void MainWindow::formatRouteWindowData(bool ok)
{
	if(!ok)
		QMaemo5InformationBox::information(this, "There was a <b>Network Error</b>, check if its your Internet connection" , QMaemo5InformationBox::DefaultTimeout);

	_routingDataWindow = new QMainWindow ( _routingWindow );
	_routingDataWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
	_routingDataWindow->setAttribute(Qt::WA_DeleteOnClose);

	_scrollForRouteDataPage = new QTextBrowser( _routingDataWindow );
	_scrollForRouteDataPage->setStyleSheet("QTextBrowser { border: 2px solid #8f8f91; ; border-radius: 15px; color: black; background-color: white}");
	_scrollForRouteDataPage->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	_scrollForRouteDataPage->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);


	QString finalStr;
	foreach(QString line, tubeapi2->results())
		finalStr += line;

	_scrollForRouteDataPage->setText( finalStr);

	_routingDataWindow->setCentralWidget(_scrollForRouteDataPage);

	//display the routing data
	_routingDataWindow->show();
}

bool MainWindow::event(QEvent *event)
{
	if (event->type() == QEvent::Gesture)
	{
		return gestureEvent(static_cast<QGestureEvent*>(event));
	}
	return QWidget::event(event);
}

bool MainWindow::gestureEvent(QGestureEvent *event)
{
	if (QGesture *pinch = event->gesture(Qt::PinchGesture))
		pinchTriggered(static_cast<QPinchGesture *>(pinch));
	return true;
}

void MainWindow::pinchTriggered(QPinchGesture *gesture)
{
	if (gesture->state() == Qt::GestureFinished) 
	{
		//update();
	}
}
