/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#include "precompiled.h"
#include "view.h"
#include "mainwindow.h"

//-----------------------------------------------------------------------------
/**
** Constructor.
**
** \param pParent The parent object.
*/
CView::CView(CMainWindow* pParent) : QGraphicsView(pParent)
{
    m_pMainWindow = pParent;
}

//-----------------------------------------------------------------------------
/**
** Destructor.
*/
CView::~CView()
{
}

//-----------------------------------------------------------------------------
/**
** Handler for the double clicks.
**
** \param pEvent The mouse event
*/
void CView::mouseDoubleClickEvent(QMouseEvent* pEvent)
{
    Q_UNUSED(pEvent);

    if (m_pMainWindow)
    {
        m_pMainWindow->setWindowState(m_pMainWindow->windowState() ^ Qt::WindowFullScreen);
    }
}

//-----------------------------------------------------------------------------
/**
** Handler for the mouse clicks.
**
** \param pEvent The mouse event
*/
void CView::mousePressEvent(QMouseEvent* pEvent)
{
    emit clicked(pEvent->pos());

    QGraphicsView::mousePressEvent(pEvent);
}

// EOF
