/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef CUSTOMBUTTON_H
#define CUSTOMBUTTON_H

class CCustomButton : public QObject, public QGraphicsItem
{
    Q_OBJECT

private:
    enum State
    {
        State_Normal,
        State_Pushed
    };

public:
    CCustomButton(QObject* pParent);
    virtual ~CCustomButton();

    void setGraphics(const QPixmap& pxBackground, const QPixmap& pxIcon, QPointF iconOffset);
    void setIcon(const QPixmap& pxIcon);

    QRectF boundingRect() const;
    void paint(QPainter* pPainter, const QStyleOptionGraphicsItem* pOption, QWidget* pWidget);

public slots:
    void onHoldTimeout();

signals:
    void clicked();
    void clickAndHold();

protected:
    virtual void mousePressEvent(QGraphicsSceneMouseEvent* pEvent);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent* pEvent);

private:
    QPixmap m_pxBackground;     ///< The background image
    QPixmap m_pxIcon;           ///< The icon for the button
    State m_State;              ///< The current state of the button
    QPointF m_IconOffset;       ///< The offset for the icon inside the button
    QTimer m_HoldTimer;         ///< Timer for the click and hold
    bool m_bIgnoreRelease;      ///< Used to skip the clicked() when clickAndHold() is emitted
};

#endif // CUSTOMBUTTON_H
