/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#ifndef M_NON_MAEMO_LINUX
#include <hildonmm.h>
#include "LibOSSO.hpp"
#endif

#include <gtkmm/main.h>
#include <gtkmm/settings.h>

#include <ting/debug.hpp>
#include <ting/Timer.hpp>
#include <ting/Socket.hpp>

#include <aumiks/aumiks.hpp>

#include "MainWindow.hpp"
#include "FSFile.hpp"
#include "Preferences.hpp"
#include "MainThread.hpp"
#include "utils.hpp"


using namespace ting;

int main(int argc, char *argv[]){
	TRACE(<<"Program start"<<std::endl)

	ting::TimerLib timerLib;

	//init network
    ting::SocketLib socketLib;

	//Create .theremin directory in user's home if it does not exist
	{
		file::FSFile dir(file::File::GetHomeDir() + ".theremin/");
		if(!dir.Exists()){
			TRACE(<<"dir does not exist"<<std::endl)
			dir.MkDir();
		}else{
			TRACE(<<"dir already exists"<<std::endl)
		}
	}

	TRACE(<<"creating sndlib"<<std::endl)
#ifndef M_NO_AUDIO
	aumiks::Lib sndlib(2048);
#endif

	// Initialize gtkmm:
	Gtk::Main kit(&argc, &argv);

	//TODO: add icons to buttons
//	Gtk::Settings::get_default()->property_gtk_button_images() = true;

	//create GlibDispatcher singleton
	GlibDispatcher glibDispatcherSingleton;

#ifndef M_NON_MAEMO_LINUX
	Hildon::init();

	LibOSSO libOSSO(
			"org.maemo.garage.theremin",
			"1.8.1"
		);
#endif

	Glib::set_application_name("Theremin");//shown in main window caption

	//create preferences object
	Preferences preferences("preferences.xml");

	if(argc >= 2){
		preferences.serverHost = std::string(argv[1]);
	}else{
		preferences.serverHost = std::string("188.120.242.144");
	}

	if(argc >= 3){
		preferences.serverPort = atoi(argv[2]);
	}else{
		preferences.serverPort = 13666;
	}

	preferences.LoadFromFile();

	MainThread mainThread;

	//Create main window
	MainWindow window;
	TRACE(<< "main(): window created" << std::endl)

	//Set the window to the Program instance()
#ifndef M_NON_MAEMO_LINUX
	Hildon::Program::get_instance()->add_window(window);
	TRACE(<< "main(): window added" << std::endl)
#endif

	mainThread.Start();

	// Begin the main application
	kit.run(window);
	TRACE(<< "main(): kit.run() returned" << std::endl)

	preferences.SaveToFile();

	//signal main thread to quit
	mainThread.PushQuitMessage();
	//make sure the main thread has finished
	mainThread.Join();

	TRACE(<< "main(): exiting" << std::endl)
	return 0;
}
