/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/*
* aumiks 0.1
*/

#pragma once

#include <ting/debug.hpp>
#include <ting/math.hpp>

#include "config.hpp"

#include "Filter.hpp"

namespace aumiks{

class FilterBiquad : public aumiks::Filter{

public:

	FilterBiquad() :
			aumiks::Filter(3, 3)
	{
		this->Clear();
	}

	void SetResonance(aumiks::real freq, aumiks::real radius){
		this->a[0] = real(1);
		this->a[2] = radius * radius;
		this->a[1] = real(-2.0) * radius * ting::Cos<real>(ting::D2Pi<real>() * freq / real(44100));

		// Use zeros at +- 1 and normalize the filter peak gain.
		this->b[0] = real(0.5) - real(0.5) * this->a[2];
		this->b[1] = real(0);
		this->b[2] = -this->b[0];
	}

//	void Clear(){
//		this->x1 = 0;
//		this->y0 = 0;
//	}

//	void SetCoefs(real coefA0, real coefA1){
//		this->a0 = coefA0;
//		this->a1 = coefA1;
//	}

	//shade superclass method Tick()
//	inline aumiks::real Tick(aumiks::real sample){
////		this->x[0] = sample;
////		this->y[0] = this->a[1] * this->x[1] + this->a[0] * this->x[0];
////		this->x[1] = this->x[0];
////
////		return this->y[0];
//		this->y0 = this->a1 * this->x1 + this->a0 * sample;
//		this->x1 = sample;
//		return this->y0;
//	}
};

}//~namespace
