#ifndef STICKYNOTESTEXTEDIT_HPP
#define STICKYNOTESTEXTEDIT_HPP

#include <QtGui>

#define STICKY_NOTES_TEXT_EDIT_INITIAL_TEXT "Your notes here!"

class StickyNotesTextEdit : public QTextEdit
{
    Q_OBJECT

private:
    bool _hasBeenFocused;

protected:
    virtual void focusInEvent(QFocusEvent *e);
    virtual void focusOutEvent(QFocusEvent *e);
    virtual void showEvent(QShowEvent *e);

public:
    explicit StickyNotesTextEdit(QWidget *parent = NULL);

signals:
    void focusChanged();

public slots:
    void removeInitialText();
    void toggleStrikeThrough();

};

#endif // STICKYNOTESTEXTEDIT_HPP
