# -*- coding: utf-8 -*-

###########################################################################
## File:        mylib.py
## Description: This file includes some cpu intensive functions.
##                With the Python to C compiler they can be converted into a
##                c module which then gets loaded from python.
##                This can bring a speed improvement of up to 19 times.
##                Tested with SHedSkin 0.6
##                In case the module can not be compiled or the file
##                lib/mylib.so is missing, Python will fallback and use
##                this Python file (mylib.py) instead.
##                This works the same, but will be much slower.
###########################################################################




###########################################################################
## Function:    IsCompiled
## Description: This function can be used to check if the c module is used
##                or the fallback to the Pyxthon code
## Parameters:  none
## Returns:     True if compiled, else False
###########################################################################
def IsCompiled():
    r=True
    #{  ##Do not remove this line
    r=False #used to detect if c module is available
    #}  ##Do not remove this line
    return r





###########################################################################
## Function:    CalculateSleepPattern
## Description: This function generates the blue sleep pattern curve
## Parameters:  ar: aray containing the derivation data,
##                arlen: leght of array ar,
##                filter: the filer array as defined in filter_data.py,
##                shift: ammount of indices the filer should be shifted, normally 0,
##                Yscale: Scaling for Y axis,
##                Yoffset: Offset for Y axis,
##                Ymax: Max Y value, curve will be limited to this value,
##                Ymin: Min Y value, curve will be limited to this value,
##                limitMovement: Max of input of array, use to limit huge spikes
## Returns:     ar_ret: array containing the curve
###########################################################################
def CalculateSleepPattern(ar, arlen, filter, shift, Yscale, Yoffset, Ymax, Ymin, limitMovement):
    len_filter=len(filter)

    ar_ret=[0]*(arlen+len_filter)

    for i in range(0, arlen): #loop arrData
        if(ar[i] > limitMovement): #limit peack values
            ar[i] = limitMovement

        for p in range(0, len_filter-1): #loop arrFilter
            ar_ret[i+p-shift] = ar_ret[i+p-shift] + ar[i]*filter[p]

    for i in range(0, arlen): #loop arrData
        value=(ar_ret[i] * Yscale/80000)-Yoffset #Yscale
        if(value > Ymax): #check range over/unterrun
            ar_ret[i] = Ymax #-int(random.uniform(1, 2))
        elif(value < Ymin):
            ar_ret[i] =Ymin
        else:
            ar_ret[i]=value

    return ar_ret





    
    
###########################################################################
## Function:    CalculateStatistic
## Description: This function calculates the statistic values
## Parameters:  ar: array containing the input data,
##                end_index: last index of array ar,
##                TotalTime_Seconds: total time of whole record,
##                Interval: intervall time between indices in sec,
##                Light_Sleep_Level: level at which light sleep starts,
##                Deep_Sleep_Level: level at which deep sleep starts,
## Returns:     arrStatData: array containing the statistics
###########################################################################
def CalculateStatistic(ar, end_index, TotalTime_Seconds, Interval, Light_Sleep_Level, Deep_Sleep_Level):
    arrStatData=[[0]*4, [0]*4, [0]*4]

    p=0
    p0=0
    while(p<end_index):
        if(ar[p]>Light_Sleep_Level): #awake
            p0=p
            while(ar[p]>Light_Sleep_Level and p<end_index): p=p+1
            arrStatData[0][0]=arrStatData[0][0]+p-p0 #Accumulated time for Awake
            arrStatData[0][1]=arrStatData[0][1]+1 #Amount of times in Awake
            if(arrStatData[0][2]<p-p0): arrStatData[0][2]=p-p0 #Max time in Awake

        elif(ar[p]>Deep_Sleep_Level): #light sleep
            p0=p
            while(ar[p]>Deep_Sleep_Level and ar[p]<=Light_Sleep_Level and p<end_index): p=p+1
            arrStatData[1][0]=arrStatData[1][0]+p-p0 #Accumulated time for Light sleep
            arrStatData[1][1]=arrStatData[1][1]+1#Amount of times in Light sleep
            if(arrStatData[1][2]<p-p0): arrStatData[1][2]=p-p0 #Max time in Light sleep

        else:
            p0=p
            while(ar[p]<=Deep_Sleep_Level and p<end_index): p=p+1
            arrStatData[2][0]=arrStatData[2][0]+p-p0 #Accumulated time for Deep sleep
            arrStatData[2][1]=arrStatData[2][1]+1#Amount of times in Deep sleep
            if(arrStatData[2][2]<p-p0): arrStatData[2][2]=p-p0 #Max time in Deep sleep

    #Accumulated time/phase
    arrStatData[0][0]=arrStatData[0][0]*Interval
    arrStatData[1][0]=arrStatData[1][0]*Interval
    arrStatData[2][0]=arrStatData[2][0]*Interval

    #Max time/phase
    arrStatData[0][2]=arrStatData[0][2]*Interval
    arrStatData[1][2]=arrStatData[1][2]*Interval
    arrStatData[2][2]=arrStatData[2][2]*Interval

    #time percent
    if(TotalTime_Seconds==0):  TotalTime_Seconds=1 #division by zero prevention
    arrStatData[0][3]=arrStatData[0][0]*100/TotalTime_Seconds
    arrStatData[1][3]=arrStatData[1][0]*100/TotalTime_Seconds
    arrStatData[2][3]=arrStatData[2][0]*100/TotalTime_Seconds

    return arrStatData




    
###########################################################################
## Function:    (none)
## Description: This code block is needed, so ShedSkin knows which kind of
##                type the parameters are (strings, integer,...)
## Parameters:  none
## Returns:     none
###########################################################################
if __name__ == '__main__':
    #those lines are needed, so Shedskin knows how the parameters of the functions are:
    IsCompiled()
    arTest=[1, 2, 3, 4, 5, 6, 7, 8, 9]
    arFiltertest=[1, 2, 3]
    CalculateSleepPattern(arTest, 1, arFiltertest, 1, 20, 10, 120, 13, 250)
    CalculateStatistic(arTest, 100, 200, 1000, 20, 10)