#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import os, sys
import string

app = QApplication(sys.argv)

try:
    file = open("/opt/SleepAnalyser/version", 'r')
    version = file.readline()
    version=version[:-1]
    build = file.readline()
    version=str(version)+ "-"+str(build)
except:
    version=""

trace = os.popen("tail -n8 /home/user/MyDocs/SleepAnalyser/error.log").read() # run tail and make the output look like a file I can read
trace=string.replace(trace, "\n", "\n  |  ")


ret = QMessageBox.question(None, "Oops! Error in SleepAnalyser "+version, "SleepAnalyser did not get closed correctly. " + \
                           "Please send an email to the author and attach the error log in\n" + \
                           "/home/user/MyDocs/SleepAnalyser/error.log\n"
                        , QMessageBox.Yes, QMessageBox.Discard)
if ret == QMessageBox.Yes:
    cmd="dbus-send --type=method_call --dest=com.nokia.modest /com/nokia/modest com.nokia.modest.MailTo string:\"" +\
    "mailto:george@ruinelli.ch?subject=Bug in SleepAnalyser "+version+"&body="+\
    "DON'T FORGET TO ATTACH THE LOG FILE! ------------------------------------ " +\
    "There is a bug in SleepAnalyser. Attached the log file from /home/user/MyDocs/SleepAnalyser/error.log" +\
    " ------------------------------------ " +\
    "Stack trace:\n"+ trace+"\""

    os.popen(cmd)
    QMessageBox.information(None, "Bug report for SleepAnalyser ",
                           "Please do not forget to attach the error log file:\n" + \
                           "/home/user/MyDocs/SleepAnalyser/error.log\n"+\
                           "Also it would be helpful to get some additional information. "+\
                           "Did it happen once? Does it happen every time? Do you use any special settings?")
    quit(1)

quit(0)
