import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

#own functions
from functions_general import *

try:
    import alarm #maemo specific
except:
    pass




###########################################################################
## 
###########################################################################
def SetAlarm():
    if(data.demo==False): #We are on a N900
        event = alarm.Event()
        event.appid = 'SleepAnalyser'
        event.message = 'Wake up (SleepAnalyser)!'   

        event.alarm_time = records.AlarmTime_seconds #in seconds

        action_stop, action_snooze = event.add_actions(2)
        action_stop.label = 'Stop'
        action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP

        action_snooze.label = 'Snooze'
        action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE

        data.AlarmID = alarm.add_event(event)
        
        event = alarm.get_event(data.AlarmID) #read out again to check if set correctly
        print "* Alarm will go off on:",  time.ctime(event.trigger)
    else:
        print "* Can not set alarm, Maemo interface not available"
        data.AlarmID=1
        
    data.AlarmIsActive=False







###########################################################################
## 
###########################################################################
def DeleteAlarm():
    if(data.AlarmID!=-1): #there is an old alarm to be deleted
        if(data.demo==False): #We are on a N900
            try:
                event = alarm.get_event(data.AlarmID) #get data of to be deleted alarm
                alarm.delete_event(data.AlarmID)
                
                print "* Delete old Alarm:",  time.ctime(event.trigger)
            except:
                pass            
        else:
            print "* Can not delete alarm, Maemo interface not available"
        
        data.AlarmID=-1
        
        if(data.AlarmIsActive==False): #if alarm never came, remove from record
            records.AlarmTime_seconds=-1
            records.AlarmTime_tuple=-1
    else:
        if(data.debug==1): print "* No alarm to be deleted"        

#    records.AlarmIsSet=False
    data.AlarmIsActive=False




###########################################################################
## 
###########################################################################
def ProcessAlarm():
    i=records.Index-data.Derivation            
    if(i>1): peak=records.arrData[3][i-1]
    else: peak=0
    now=Tuple2Seconds(time.localtime())
    if(peak>data.Trigger): #big Movement
       if(records.AlarmIsSet==True and data.AlarmIsActive==False and now>=records.AlarmTimeWindowStart_seconds and now<records.AlarmTimeWindowEnd_seconds):
            #print big movement and we are in alarm time window, update alarm time, set alarm off
            print "************ ALARM ALARM (Movement over trigger level)"
            DeleteAlarm() #delete old alarm if existing
#            h=int(strftime("%H", time.localtime()))
#            m=int(strftime("%M", time.localtime()))
#            print "* Set new Alarm to current time:",  h,  ":",  m
#            now=int(strftime("%H", time.localtime()))*3600+int(strftime("%M", time.localtime()))*60
            records.AlarmTime_tuple=time.localtime()#set to now
            records.AlarmTime_seconds=Tuple2Seconds(records.AlarmTime_tuple) 
            SetAlarm() #set alarm to go off now
            records.Trigger=data.Trigger #update Trigger level on alarm occurence
            data.AlarmIsActive=True
    elif(now>=records.AlarmTimeWindowEnd_seconds): #End of alarm time window, set alarm off anyway
        if(records.AlarmIsSet==True and data.AlarmIsActive==False): #Alarm is set and not active yet
            print "************ ALARM ALARM (End of Alarm Time Window)"
            records.AlarmTime_tuple=time.localtime()#set to now (just for record)
            records.AlarmTime_seconds=Tuple2Seconds(records.AlarmTime_tuple) 
            records.Trigger=data.Trigger #update Trigger level on alarm occurence
            data.AlarmIsActive=True

#    print "records.AlarmIsSet", records.AlarmIsSet 
#    print "data.AlarmIsActive:",  data.AlarmIsActive
#    print ""
            
            
