#ifndef SUMMARYWINDOWMAEMO_H
#define SUMMARYWINDOWMAEMO_H

#include <QPushButton>
#include <QLabel>
#include <QVBoxLayout>
#include "conceptschart.h"
#include "expensesgraph.h"
#include <QAction>
#include <QFrame>
#include <QMaemo5ValueButton>
#include "summarywindow.h"

class SummaryWindowMaemo : public SummaryWindow
{
        Q_OBJECT
 public:
        SummaryWindowMaemo(int minYear,
                           int minMonth,
                           int maxYear,
                           int maxMonth,
                           QWidget *parent = 0);
        ~SummaryWindowMaemo();
        void setSummaryData(SummaryData *data);

 protected:
        void mousePressEvent(QMouseEvent *event);

 private slots:
        void loadButtonClicked();
        void startDateClicked();
        void endDateClicked();
        void statisticsSelected();
        void itemsSelected();
        void evolutionSelected();

 private:
        QAction *statistics;
        QAction *items;

        /* period stuff */
        QLabel *fromLabel;
        QLabel *toLabel;
        QVBoxLayout *vbox;

        int _minYear;
        int _minMonth;
        int _maxYear;
        int _maxMonth;
        int _startYear;
        int _startMonth;
        int _endYear;
        int _endMonth;
        QPushButton *loadButton;
        QMaemo5ValueButton *startDate;
        QMaemo5ValueButton *endDate;

        /* statistics stuff */
        QFrame *statsBox;
        QLabel *totalBudget;
        QLabel *totalExpense;
        QLabel *totalSaved;
        QLabel *minExpense;
        QLabel *maxExpense;
        QLabel *averageExpense;
        QLabel *minSaved;
        QLabel *maxSaved;
        QLabel *averageSaved;

        /* items stuff */
        ConceptsChart *chart;

        QLabel *viewLabel;
        ExpensesGraph *graph;

        SummaryData *summaryData;

};
#endif
