#ifndef EXPENSEDETAILSDIALOGMAEMO_H
#define EXPENSEDETAILSDIALOGMAEMO_H

#include <QLineEdit>
#include <QList>
#include <QDate>
#include "expense.h"
#include "concept.h"
#include <QDialogButtonBox>
#include <QMaemo5ValueButton>
#include <QStandardItemModel>
#include <QMaemo5ListPickSelector>
#include "expensedetailsdialog.h"

class ExpenseDetailsDialogMaemo : public ExpenseDetailsDialog
{
        Q_OBJECT
 public:
        ExpenseDetailsDialogMaemo(const QDate &date,
                                  QStandardItemModel *concepts,
                                  QWidget *parent = 0,
                                  Qt::WindowFlags f = 0);

        ExpenseDetailsDialogMaemo(const QDate &date,
                                  QStandardItemModel *concepts,
                                  QStandardItemModel *expenses,
                                  int row,
                                  QWidget *parent = 0,
                                  Qt::WindowFlags f = 0);

        ~ExpenseDetailsDialogMaemo();

 private slots:
        void conceptSelected(const QString &value);
        void checkValues();
        void deleteClicked();

 private:
        void buildUI (const QDate &date,
                      QStandardItemModel *concepts);
        QString humanizeDay(const QDate &date,
                            const QDate &currentDate,
                            bool isCurrentMonth);

        QMaemo5ValueButton *day;
        QMaemo5ListPickSelector *daySelector;
        QLineEdit *amount;
        QMaemo5ValueButton *concept;
        QMaemo5ListPickSelector *conceptSelector;
        QLineEdit *description;
        int expenseId;
        QDialogButtonBox *box;
        bool newExpense;
};
#endif
