#include "datechooserdialogmaemo.h"
#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QStandardItemModel>
#include <QStandardItem>
#include <QDate>
#include <QModelIndex>
#include <QModelIndexList>
#include <QItemSelectionModel>
#include <QMaemo5InformationBox>

#define DIALOG_MINIMUM_HEIGHT 300

int DateChooserDialogMaemo::year = 0;
int DateChooserDialogMaemo::month = 0;
bool DateChooserDialogMaemo::dialogAccepted = false;

DateChooserDialogMaemo::DateChooserDialogMaemo(int minYear,
                                               int minMonth,
                                               int maxYear,
                                               int maxMonth,
                                               int selectedYear,
                                               int selectedMonth,
                                               QWidget *parent,
                                               Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Choose a date"));
        setMinimumHeight(DIALOG_MINIMUM_HEIGHT);

        QHBoxLayout *layout = new QHBoxLayout (this);

        _minYear = minYear;
        _minMonth = minMonth;
        _maxYear = maxYear;
        _maxMonth = maxMonth;

        QStandardItemModel *monthModel = new QStandardItemModel(0, 1, this);
        for (int i = 0; i<12; i++) {
                QStandardItem *item = new QStandardItem (QDate::longMonthName(i + 1));
                item->setTextAlignment(Qt::AlignCenter);
                item->setEditable(false);
                monthModel->appendRow(item);
        }
        monthList = new QListView();
        monthList->setModel(monthModel);
        monthList->setProperty("FingerScrollable", true);
        layout->addWidget(monthList, 1);
        if (selectedMonth) {
                /* seems that there is a bug in the scrollTo function, and the seleected
                   item is not centered. I guess this will be fixed at some point */
                QItemSelectionModel *monthSelection = monthList->selectionModel();
                QModelIndex index = monthModel->index(selectedMonth - 1, 0);
                monthSelection->select(index, QItemSelectionModel::Select);
                monthList->scrollTo(index, QAbstractItemView::PositionAtCenter);
        }

        QStandardItemModel *yearModel = new QStandardItemModel(0, 1, this);
        for (int i = minYear; i<= maxYear; i++) {
                QStandardItem *item = new QStandardItem (QString("%1").arg(i));
                item->setTextAlignment(Qt::AlignCenter);
                item->setEditable(false);
                yearModel->appendRow(item);
        }
        yearList = new QListView();
        yearList->setModel(yearModel);
        yearList->setProperty("FingerScrollable", true);
        layout->addWidget(yearList, 1);
        if (selectedYear) {
                /* seems that there is a bug in the scrollTo function, and the seleected
                   item is not centered. I guess this will be fixed at some point */
                QItemSelectionModel *yearSelection = yearList->selectionModel();
                QModelIndex index = yearModel->index(selectedYear - minYear, 0);
                yearSelection->select(index, QItemSelectionModel::Select);
                yearList->scrollTo(index, QAbstractItemView::PositionAtCenter);
        }

        QDialogButtonBox *box = new QDialogButtonBox(QDialogButtonBox::Cancel, Qt::Vertical);
        box->addButton(new QPushButton(tr("Done")), QDialogButtonBox::AcceptRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(dateSelected()));
        connect(box, SIGNAL(rejected()), this, SLOT(dateCancelled()));
}

DateChooserDialogMaemo::~DateChooserDialogMaemo()
{
}

void DateChooserDialogMaemo::dateSelected()
{
        int y = 0;
        int m = 0;

        QItemSelectionModel *selection = monthList->selectionModel();
        QModelIndexList indexes = selection->selectedRows();
        if(!indexes.isEmpty()) {
                m = indexes[0].row() + 1;
        } else {
            QMaemo5InformationBox::information(this, tr("Choose a month"));
            return;
        }

        selection = yearList->selectionModel();
        indexes = selection->selectedRows();
        if(!indexes.isEmpty()) {
                y = _minYear + indexes[0].row();
        } else {
            QMaemo5InformationBox::information(this, tr("Choose a year"));
            return;
        }

        if (y == _minYear && m < _minMonth) {
                QString message(tr("Minimum date is %1 %2")
                                .arg(QDate::longMonthName(_minMonth))
                                .arg(_minYear));
                QMaemo5InformationBox::information(this, message);
                return;
        }

        if (y == _maxYear && m > _maxMonth) {
                QString message(tr("Maximum date is %1 %2")
                                .arg(QDate::longMonthName(_maxMonth))
                                .arg(_maxYear));
                QMaemo5InformationBox::information(this, message);
                return;
        }

        year = y;
        month = m;
        dialogAccepted = true;
        accept();
}

void DateChooserDialogMaemo::dateCancelled()
{
        dialogAccepted = false;
        reject();
}

bool DateChooserDialogMaemo::askDate(int minYear,
                                     int minMonth,
                                     int maxYear,
                                     int maxMonth,
                                     int &selectedYear,
                                     int &selectedMonth)
{
        year = 0;
        month = 0;
        dialogAccepted = false;

        DateChooserDialogMaemo dialog(minYear,
                                      minMonth,
                                      maxYear,
                                      maxMonth,
                                      selectedYear,
                                      selectedMonth);
        dialog.exec();

        if (dialogAccepted) {
                /* get data from static vars and set it to the parameters got */
                selectedYear = year;
                selectedMonth = month;
        }

        return dialogAccepted;
}
