#ifndef MAINWINDOWDESKTOP_H
#define MAINWINDOWDESKTOP_H

#include <QLineEdit>
#include <QPushButton>
#include <QLabel>
#include <QMouseEvent>
#include <QAction>
#include <QPushButton>
#include "monthdata.h"
#include "expensesgraph.h"
#include "mainwindow.h"

class MainWindowDesktop : public MainWindow
{
        Q_OBJECT
 public:
        MainWindowDesktop(QWidget *parent=0);

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

        void setMonthData (MonthData *data);
        void message(const QString& text);

 protected:
        void mousePressEvent(QMouseEvent *event);

 private slots:
        void expensesChanged();
        void budgetChanged();

 private:
        void updateAll();
        void updateDateLabel();
        void updateBudgetLabel();
        void updateTotalLabel();
        void updateSavedLabel();
        void updateGraph();
        void updateAccountLabel();

        MonthData *month;
        ExpensesGraph *graph;
        QLabel *dateLabel;
        QLabel *budgetLabel;
        QLabel *totalLabel;
        QLabel *savedLabel;
        QAction *budgetAction;
        QAction *expensesAction;
        QAction *scheduledAction;
        QAction *summaryAction;
        QPushButton *previous;
        QPushButton *next;
};
#endif
