#include "expenseslistdesktop.h"
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QTreeView>
#include <QPushButton>
#include <QLabel>
#include <QIcon>
#include "global.h"

ExpensesListDesktop::ExpensesListDesktop(QStandardItemModel *expenses,
                                         QWidget *parent)
        : ExpensesList (parent)
{
        setWindowTitle(tr("Expenses"));
        setAttribute(Qt::WA_DeleteOnClose);
        setWindowFlags(windowFlags() | Qt::Window);

        QVBoxLayout *layout = new QVBoxLayout (this);

        QTreeView *tree = new QTreeView();
        tree->setModel(expenses);
        tree->setColumnHidden(0, true);
        tree->setColumnWidth(1, 50);
        tree->setColumnWidth(2, 70);
        tree->setColumnWidth(3, 150);
        tree->setColumnWidth(4, 200);
        layout->addWidget(tree, 1);

        connect (tree, SIGNAL(activated(const QModelIndex&)),
                 this, SIGNAL(expenseDetailsSelected(QModelIndex)));

        QPushButton *newButton = new QPushButton(tr("New"));
        newButton->setIcon(QIcon(GENERAL_ADD_ICON));
        layout->addWidget(newButton, 0, Qt::AlignRight | Qt::AlignVCenter);
        connect(newButton, SIGNAL(clicked()), this, SIGNAL(newExpenseSelected()));
}

ExpensesListDesktop::~ExpensesListDesktop()
{
}

QSize ExpensesListDesktop::minimumSizeHint() const
{
        return QSize(600, 200);
}

QSize ExpensesListDesktop::sizeHint() const
{
        return QSize(600, 200);
}
