#include "confirmationdialogdesktop.h"
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QLabel>

bool ConfirmationDialogDesktop::dialogAccepted = false;

ConfirmationDialogDesktop::ConfirmationDialogDesktop(const QString &message,
                                                     QWidget *parent,
                                                     Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Confirm action"));

        QVBoxLayout *layout = new QVBoxLayout (this);

        QLabel *label = new QLabel(message);
        label->setWordWrap(true);
        layout->addWidget(label, 1);

        QDialogButtonBox *box = new QDialogButtonBox(Qt::Horizontal);
        box->addButton(new QPushButton(tr("Yes")), QDialogButtonBox::YesRole);
        box->addButton(new QPushButton(tr("No")), QDialogButtonBox::NoRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(confirmationAccepted()));
        connect(box, SIGNAL(rejected()), this, SLOT(confirmationRejected()));
}

ConfirmationDialogDesktop::~ConfirmationDialogDesktop()
{
}

void ConfirmationDialogDesktop::confirmationAccepted()
{
        ConfirmationDialogDesktop::dialogAccepted = true;
        accept();
}

void ConfirmationDialogDesktop::confirmationRejected()
{
        ConfirmationDialogDesktop::dialogAccepted = false;
        reject();
}

bool ConfirmationDialogDesktop::askConfirmation(const QString &message,
                                                QWidget *parent)
{
        dialogAccepted = false;
        ConfirmationDialogDesktop dialog(message, parent);
        dialog.exec();
        return dialogAccepted;
}

QSize ConfirmationDialogDesktop::minimumSizeHint() const
{
        return QSize(400, 250);
}

QSize ConfirmationDialogDesktop::sizeHint() const
{
        return QSize(400, 250);
}
