#include <QVBoxLayout>
#include <QFormLayout>
#include <QDialogButtonBox>
#include <QLabel>
#include <QMessageBox>
#include <QPushButton>
#include "budgetdialogdesktop.h"

BudgetDialogDesktop::BudgetDialogDesktop(double current,
                                         QWidget *parent,
                                         Qt::WindowFlags f)
        : BudgetDialog (parent, f)
{

        setWindowTitle(tr("Modify month budget"));

        QVBoxLayout *layout = new QVBoxLayout (this);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        layout->addLayout (form, 1);

        _budget = new QLineEdit(QString("%1").arg(current));
        form->addRow (new QLabel(tr("Month budget")), _budget);

        QDialogButtonBox *box = new QDialogButtonBox (QDialogButtonBox::Cancel);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClicked()));
        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
}

void BudgetDialogDesktop::saveClicked()
{
        double newBudget = _budget->text().toDouble();

        if (_budget->text() != "" && newBudget == 0) {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Invalid amount format"));
                msgBox.exec();
                return;
        }

        accept();
        emit changeBudget(newBudget);
}

QSize BudgetDialogDesktop::minimumSizeHint() const
{
        return QSize(300, 100);
}

QSize BudgetDialogDesktop::sizeHint() const
{
        return QSize(300, 100);
}
