#include "account.h"

Account::Account(int id,
                 const QString &name,
                 double budget,
                 QObject *parent)
        : QObject(parent)
{
        _id = id;
        _name.append(name);
        _budget = budget;
}

Account::Account(int id, QObject *parent)
        :QObject(parent)
{
        _id = id;
}

int Account::id()
{
        return _id;
}

const QString& Account::name()
{
        return _name;
}

double Account::budget()
{
        return _budget;
}

void Account::setName(const QString &name)
{
        _name = name;
}

void Account::setBudget(double budget)
{
        _budget = budget;
}
