#ifndef FILELIST_H
#define FILELIST_H

#include <QObject>
#include <QStringList>

class VideoFile;
class QDir;
class QFileInfo;
class FileSearchDialog;

typedef QList<QFileInfo> QFileInfoList;

class FileList : public QObject
{
    Q_OBJECT;

public:

    enum SortCriteria {
        ESortByName,
        ESortBySize,
        ESortByResumePos
    };

public:
    FileList( QObject* parent );
    ~FileList();

public:
    void searchFiles( const QList<QString>& searchFolders, FileSearchDialog& parent );
    const QList<VideoFile*>& files();
    VideoFile* file( int idx );

    /**
     * Sorts the files on given criteria and order.
     */
    void sortFileList( SortCriteria criteria, Qt::SortOrder order );

private:

    void updateFileList( const QFileInfoList& files );

    /**
     * Searches files recursively in given dir.
     */
    void getFilesInDir( const QDir& dir, QFileInfoList& fileList, FileSearchDialog& progress );

    void loadFileList();
    void saveFileList();

private:
    QList<VideoFile*> m_files;
    QStringList m_knownExtensions;
    SortCriteria m_sortCriteria;
    Qt::SortOrder m_sortOrder;
};

#endif // FILELIST_H
