#!/usr/bin/env python
"""
 @file: ListMyPosts.py
  File is a part of Scribo Project
  Module implements viewing list of post from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 23.06.2010
"""


from PyQt4 import QtCore
from PyQt4 import QtGui
from ldm.Profile import main_prof
#from ldm.SqlDriver import TIME_FORMAT
from ToolbarWindow import ToolbarWindow
from MainWindow import *

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2009/12/11 $"
__copyright__ = ""
__license__ = "GPLv2"

DATE_TIME_FORMAT = "dd MMM yyyy hh:mm:ss"
DATE_FORMAT_SQL = "yyyy-MM-dd hh:mm:ss"
SORT_DATE = 0
SORT_TITLE = 1
SORT_READ = 2
DESC = "DESC"
ASC = "ASC"

class ListMyPosts(MainWindow):
    """
    class for draw list of posts window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent, friend = None):
        """ 
        initialization "list of posts" window
        @return
        """
        # if friend isn't none, show friend's post
        self.friend = friend
        super(ListMyPosts,self).__init__(parent)
        self.centr_widg = QtGui.QWidget(self)
        self.create_actions()
        self.parent = parent
        self.filter_list = []
        #in the begining all posts are shown
        self.flag_is_filter = False
        self.flag_is_sort = False

        toolbar = self.create_toolbar()

        self.hbox = QtGui.QHBoxLayout()
        self.vbox_content = QtGui.QVBoxLayout()
        self.hbox_sort = QtGui.QHBoxLayout()
        self.mes_list = self.list_posts(friend)
        
        #widget's for sorting
        label_sort = QtGui.QLabel(QtCore.QCoreApplication.translate("ListMyPosts","Sort by:"))
        button_asc = QtGui.QPushButton()
        button_desc = QtGui.QPushButton()
        button_asc.setIcon(QtGui.QIcon("../data/en/sort_asc.png"))
        button_desc.setIcon(QtGui.QIcon("../data/en/sort_desc.png"))    
       
        self.combo_sort = QtGui.QComboBox()
        self.combo_sort.addItem(QtCore.QCoreApplication.translate("ListMyPosts","On date"))
        self.combo_sort.addItem(QtCore.QCoreApplication.translate("ListMyPosts","On title"))     
        self.combo_sort.addItem(QtCore.QCoreApplication.translate("ListMyPosts","On read/unread"))

        self.hbox_sort.addWidget(label_sort)
        self.hbox_sort.addWidget(self.combo_sort, 2,QtCore.Qt.AlignVCenter)
        self.hbox_sort.addWidget(button_asc)
        self.hbox_sort.addWidget(button_desc)

        self.vbox_content.addLayout(self.hbox_sort)
        self.vbox_content.addWidget(self.mes_list)

        self.hbox.addWidget(toolbar)
        self.hbox.addSpacing(10)
        self.hbox.addLayout(self.vbox_content)

        self.connect(button_asc, QtCore.SIGNAL("clicked()"),self.sort_post_asc)
        self.connect(button_desc, QtCore.SIGNAL("clicked()"),self.sort_post_desc)

        self.centr_widg.setLayout(self.hbox)
        self.setCentralWidget(self.centr_widg)
        self.show()


    def create_menus(self):
        """                                                                                                                                                 
        create menu
        @param                                                                                                                                              
        @return                                                                                                                                             
        """
        super(ListMyPosts,self).create_menus()
        self.filter_act = QtGui.QAction(QtCore.QCoreApplication.translate("ListMyPosts","Filters"), self)
        self.filter_act.setShortcut(QtCore.QCoreApplication.translate("ListMyPosts","Ctrl+N"))
        self.connect(self.filter_act, QtCore.SIGNAL("triggered()"),
                                  self.filter_mes_box)
        self.main_menu.addAction(self.filter_act)



    def list_posts(self, friend):
        """
        fill list of posts
        @param
        @return
        """
        list_widget = QtGui.QListWidget(self.centr_widg)
        self.list = self.get_messages(friend)
        index = 0

        if len(self.list) == 0:
            from ConfigDriver import config
            c = config.get_bool('UI', 'warning_press_refresh')
            if not c:
                msg = QtGui.QMessageBox()
                msg.setWindowTitle(QtCore.QCoreApplication.translate("ListMyPosts","Refresh message"))
                show_button = QtGui.QCheckBox(QtCore.QCoreApplication.translate("ListMyPosts","Don't show this message again"), msg)
                title_label = QtGui.QLabel(QtCore.QCoreApplication.translate("ListMyPosts","Press \"Refresh\" to update post"), msg)
                msg.layout().addWidget(title_label, 0, 0)
                msg.layout().addWidget(show_button, 1, 0)
                cancel_button = msg.addButton(QtGui.QMessageBox.Close)
                msg.exec_()

                if msg.clickedButton() == cancel_button:
                    if show_button.isChecked():
                        config.set('UI', 'warning_press_refresh', True)


        for mes in self.list:
            """
            date = mes.date
            import time
            datetime = time.strptime(date, "%Y-%m-%d %H:%M:%S")
            date = time.strftime("%a, %d %b %Y %H:%M", datetime)
            """
            if not mes.title:
                title = unicode(QtCore.QCoreApplication.translate("ListMyPosts","no subject"))
            else:
                title = unicode(mes.title)
            #text = date.decode('utf8') + "  " + title
            
            text = title

            author = mes.poster
            if author:
                icon = author.get_icon()
                if not icon:
                    icon = ""
            else:
                icon = ""
            new_item = QtGui.QListWidgetItem(QtGui.QIcon(QtCore.QString(icon)),
                                             text,
                                             list_widget)
            new_item.setData(QtCore.Qt.UserRole, QtCore.QVariant(index))
            if not mes.read:
                new_item.setTextColor(QtGui.QColor(QtCore.Qt.green)) 
            index = index + 1
            del text
            del title
            #del date
        self.connect(list_widget, QtCore.SIGNAL("itemDoubleClicked(QListWidgetItem*)"),
                     self.view_message)
        return list_widget

    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=self.centr_widg)
        file_tool_bar.addWidget(self.refresh_act)
        file_tool_bar.addWidget(self.del_act)
        if self.friend:
            self.del_act.setDisabled(True)
        self.connect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
                             self.home_window)
        return file_tool_bar


    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """
        self.refresh_act = QtGui.QToolButton(self.centr_widg)
        self.refresh_act.setIcon(QtGui.QIcon("../data/en/refresh.png"))
        self.refresh_act.setText(QtCore.QCoreApplication.translate("ListMyPosts","Refresh"))
        self.refresh_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.refresh_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)

        self.connect(self.refresh_act, QtCore.SIGNAL("clicked()"),
                     self.reload_window)

        self.del_act = QtGui.QToolButton(self.centr_widg)
        self.del_act.setIcon(QtGui.QIcon("../data/en/post_delete.png"))
        self.del_act.setText(QtCore.QCoreApplication.translate("ListMyPosts","Delete"))
        self.del_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.del_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.del_act, QtCore.SIGNAL("clicked()"),
                     self.delete_message)


    def view_message(self, item):
        """        
        view choosing post
        @param
        @return       
        """
        index = item.data(QtCore.Qt.UserRole).toString().toInt()[0]
        if self.flag_is_filter or self.flag_is_sort:
            self.list = self.filter_list
        mes = self.list[index]
        item.setTextColor(QtCore.Qt.white)
        if not self.flag_is_filter and not self.flag_is_sort:
            view_widg = ViewMessage(self, self.get_messages(self.friend), mes)
        else:
            view_widg = ViewMessage(self, self.filter_list, mes)
        

    def delete_message(self):
        """        
        delete choosing post
        @param
        @return       
        """
        ret = QtGui.QMessageBox.information(self, QtCore.QCoreApplication.translate("ListMyPosts","Scribo"),
                               QtCore.QCoreApplication.translate("ListMyPosts","Do you really want to delete post?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        if (ret == QtGui.QMessageBox.No):
            return
        if self.flag_is_filter or self.flag_is_sort:
            self.list = self.filter_list
        list = self.mes_list.selectedItems()
        if list:
            for item in list:
                index = item.data(QtCore.Qt.UserRole).toString().toInt()[0]
                mes = self.list[index]
                try:
                    mes.poster.del_post(mes)
                except WarningExc, exc:
                    author = mes.poster
                    try:
                        author.refresh_post(mes)
                    except WarningExc, ex:
                        super(ListMyPosts, self).show_warning(ex)
                        return
                    else:
                        main_window.show_warning(exc)
                else:
                    self.mes_list.removeItemWidget(item)
                    item.setHidden(True)
                    item.setSelected(False)

        else:
            QtGui.QMessageBox.information(self, QtCore.QCoreApplication.translate("ListMyPosts","Scribo"),
                               QtCore.QCoreApplication.translate("ListMyPosts","Please, choose messages to delete!"),
                               QtGui.QMessageBox.Yes)

    def reload_window(self):
        """
        refresh list of posts 
        @param          
        @return
        """
        self.progress = MyProgress(self)
        self.refresh_messages()
        self.progress.close()

    def end_refresh(self):
        """
        update list messages from database
        """
        self.vbox_content.removeWidget(self.mes_list)
        self.mes_list.deleteLater()
        self.mes_list = self.list_posts(self.friend)
        self.vbox_content.addWidget(self.mes_list)

    def callback(self):
        """
        update toolbar
        """
        self.progress.setValue(100 * (self.progress.value_progress / (self.progress.value_progress + 4.5)))
        self.progress.value_progress = self.progress.value_progress + 1.1
        QtCore.QCoreApplication.processEvents()
        

    def refresh_messages(self):
        """
        update list of messages from network
        """
        # if friend's post are shown, then these posts are refresh 
        if not self.friend:
            list_acc = main_prof.accounts
            for acc in list_acc:
                try:
                    acc.refresh_posts(self.callback)
                except WarningExc, exc:
                    main_window.show_warning(exc)
        else:
            list_acc = main_prof.accounts
            for acc in list_acc:
                try:
                    acc.refresh_friends_page(self.callback)
                except WarningExc, exc:
                    main_window.show_warning(exc)
        self.flag_is_filter = False
        self.flag_is_sort = False



    def get_messages(self, friend):
        """
        getting all messages,
        if posts have already sorted or filtered, display their
        """
        if not self.flag_is_filter and not self.flag_is_sort:
            if not friend:
                return main_prof.get_posts()
            else:
                return friend.get_posts()
        else:
            return self.filter_list



    def filter_mes_box(self):
        """
        dialog with filters for list messages
        """
        self.f_dial = QtGui.QMessageBox()
        hbox = QtGui.QVBoxLayout()
        but_box = QtGui.QDialogButtonBox()
        but_box.setOrientation(QtCore.Qt.Vertical)

        self.f_dial.setWindowTitle(QtCore.QCoreApplication.translate("ListMyPosts","Filters"))
        self.f_dial.setOrientation(QtCore.Qt.Vertical)

        self.poster_button = but_box.addButton(QtCore.QCoreApplication.translate("ListMyPosts","By author"),
                                     QtGui.QDialogButtonBox.ActionRole)
        self.date_button = but_box.addButton(QtCore.QCoreApplication.translate("ListMyPosts","By date"),
                                       QtGui.QDialogButtonBox.ActionRole)
        self.read_button = but_box.addButton(QtCore.QCoreApplication.translate("ListMyPosts","By read/unread"),
                                     QtGui.QDialogButtonBox.ActionRole)
        self.text_button = but_box.addButton(QtCore.QCoreApplication.translate("ListMyPosts","By content"),
                                      QtGui.QDialogButtonBox.ActionRole)
        self.poster_button.setMinimumWidth(350)
        self.date_button.setMinimumWidth(350)
        self.read_button.setMinimumWidth(350)
        self.text_button.setMinimumWidth(350)

        self.find_in_found = QtGui.QCheckBox(QtCore.QCoreApplication.translate("ListMyPosts","Search in results"))
        cancel_button = self.f_dial.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        
        if self.flag_is_filter:
            hbox.addWidget(self.find_in_found, -1, QtCore.Qt.AlignVCenter)
            self.find_in_found.adjustSize()
      
        hbox.addWidget(but_box, 2, QtCore.Qt.AlignHCenter)
        self.f_dial.layout().addLayout(hbox, 0, 0, -1, -1, QtCore.Qt.AlignVCenter)
        but_box.adjustSize()
         
        self.connect(but_box, QtCore.SIGNAL("clicked(QAbstractButton *)"), self.filter_choose)
      
        self.f_dial.exec_()
        if self.f_dial.clickedButton() == QtGui.QMessageBox.Abort:
            pass
        else:
            return

    def filter_choose(self, button):
        """
        handler for choosing type filter
        """
        #search in all message(not in search)
        if not self.filter_list or not self.find_in_found.isChecked():
            self.filter_list = []
        if button == self.poster_button:
            self.f_dial.reject()
            self.choose_poster()
        elif button == self.date_button:
            self.f_dial.reject()
            self.choose_date()
        elif button == self.read_button:
            self.f_dial.reject()
            self.choose_read()
        elif button == self.text_button:
            self.f_dial.reject()
            self.choose_text()
        else:
            return
        self.f_dial.reject()
        
    def create_combo_filter(self):
        """
        combo box with all user's accounts
        """
        acc_combo = QtGui.QComboBox()
        self.f_account = []

        if not self.friend:
            for acc in main_prof.accounts:
                self.f_account.append(acc)
                path_ava = acc.path_to_ava
                if not path_ava:
                    acc_combo.addItem(acc.username)
                else:
                    acc_combo.addItem(QtGui.QIcon(path_ava), acc.username)
        else:
            self.f_account.append(self.friend)
            path_ava = self.friend.path_to_ava
            if not path_ava:
                acc_combo.addItem(self.friend.username)
            else:
                acc_combo.addItem(QtGui.QIcon(path_ava), self.friend.username)
        return acc_combo

    def choose_poster(self):
        """
        handler for choosing filter by poster
        """
        msg = QtGui.QMessageBox()
        msg.setWindowTitle(QtCore.QCoreApplication.translate("ListMyPosts","Filters"))
    
        title_label = QtGui.QLabel(QtCore.QCoreApplication.translate("ListMyPosts","Choose poster:"), msg)
        msg.layout().addWidget(title_label, 0, 0)

        acc_combo = self.create_combo_filter()
        msg.layout().addWidget(acc_combo, 1, 0)

        ok_button = msg.addButton(QtCore.QCoreApplication.translate("ListMyPosts","OK"),
                                    QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()

        if msg.clickedButton() == cancel_button:
            return
        if msg.clickedButton() == ok_button:
            index = acc_combo.currentIndex()
            first_value = self.f_account[index].id  
            from ldm.Message import POSTER_F
            field = POSTER_F
            temp_list = []
            #get filter by poster
            if self.friend:
                temp_list = self.ui_filter_msg(field, first_value, filt_list = self.filter_list,  acc_id = self.friend.id)
            else:
                for acc in main_prof.accounts:
                    temp_list.extend(self.ui_filter_msg(field, first_value, filt_list = self.filter_list, acc_id = acc.id))
            #print self.filter_list
            self.filter_list = temp_list
            #refresh displayed list of posts
            self.flag_is_filter = True
            self.end_refresh()
        return

    def choose_text(self):
        """
        handler for choosing filter by content
        """
        #text contents searching text, ok - result of accepting dialog or ignoring
        text, ok = QtGui.QInputDialog.getText(self, QtCore.QCoreApplication.translate("ListMyPosts","Filters"), QtCore.QCoreApplication.translate("ListMyPosts","Search text:"))
        if ok and text:
            first_value = text
            from ldm.Message import TEXT_F
            field = TEXT_F
            temp_list = []
            # if is friend, we should filter's his/her posts
            if self.friend:
                temp_list = self.ui_filter_msg(field, first_value, filt_list = self.filter_list, acc_id = self.friend.id)
            else:
                for acc in main_prof.accounts:
                    temp_list.extend(self.ui_filter_msg(field, first_value, filt_list = self.filter_list, acc_id = acc.id))
            #print self.filter_list
            self.filter_list = temp_list
            #refresh displayed list of posts                                                                                                       
            self.flag_is_filter = True
            self.end_refresh()
        return

    def choose_read(self):
        """
        handler for choosing filter by read/unread
        """
        text, ok = QtGui.QInputDialog.getItem(self, QtCore.QCoreApplication.translate("ListMyPosts","Filters"), QtCore.QCoreApplication.translate("ListMyPosts","Search text:"),['read','unread'], current = 0, editable = False)
        if ok and text:
            #true = 1, false = 0
            if text == "read":
                first_value = str(1)
            else:
                first_value = str(0)
            from ldm.Message import READ_F
            field = READ_F
            temp_list = []
            if self.friend:
                temp_list = self.ui_filter_msg(field, first_value,filt_list = self.filter_list, acc_id = self.friend.id)
            else:
                for acc in main_prof.accounts:
                    temp_list.extend(self.ui_filter_msg(field, first_value, filt_list = self.filter_list, acc_id = acc.id))
            self.filter_list = temp_list
            #print self.filter_list
            #refresh displayed list of posts                                                                                                               
            self.flag_is_filter = True
            self.end_refresh()
        return

    def choose_date(self):
        """
        handler foe choosing filter by date
        """
        msg = QtGui.QMessageBox()
        msg.setWindowTitle(QtCore.QCoreApplication.translate("ListMyPosts","Filters"))
        title_label = QtGui.QLabel(QtCore.QCoreApplication.translate("ListMyPosts","Choose date:"), msg)
        since_label = QtGui.QLabel(QtCore.QCoreApplication.translate("ListMyPosts","Since: "), msg)
        to_label = QtGui.QLabel(QtCore.QCoreApplication.translate("ListMyPosts","To: "), msg)
        msg.layout().addWidget(title_label, 0, 0)
        #need two date-time-edit
        date_edit_first = QtGui.QDateTimeEdit(QtCore.QDate.currentDate())
        date_edit_first.setMinimumDate(QtCore.QDate.currentDate().addDays(-365))
        date_edit_first.setMaximumDate(QtCore.QDate.currentDate().addDays(365))
        date_edit_first.setDisplayFormat(DATE_TIME_FORMAT)

        date_edit_sec = QtGui.QDateTimeEdit(QtCore.QDate.currentDate())
        date_edit_sec.setMinimumDate(QtCore.QDate.currentDate().addDays(-365))
        date_edit_sec.setMaximumDate(QtCore.QDate.currentDate().addDays(365))
        date_edit_sec.setDisplayFormat(DATE_TIME_FORMAT)

        msg.layout().addWidget(since_label, 1, 0)
        msg.layout().addWidget(to_label, 2, 0)
        msg.layout().addWidget(date_edit_first, 1, 1)
        msg.layout().addWidget(date_edit_sec, 2, 1)   

        ok_button = msg.addButton(QtCore.QCoreApplication.translate("ListMyPosts","OK"),
                                    QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()

        if msg.clickedButton() == cancel_button:
                return
        if msg.clickedButton() == ok_button:
            # convert getting date in type for sql database
            first_value = date_edit_first.dateTime().toString(DATE_FORMAT_SQL)
            second_value = date_edit_sec.dateTime().toString(DATE_FORMAT_SQL)
            from ldm.Message import DATE_F
            field = DATE_F
            if first_value > second_value:
                QtGui.QMessageBox.warning(self, QtCore.QCoreApplication.translate("ListMyPosts","Scribo"),
                               QtCore.QCoreApplication.translate("ListMyPosts","Date in first field should be less!"),
                               QtGui.QMessageBox.Yes)
                self.choose_date()
            else:
                temp_list = []    
                if self.friend:
                    temp_list = self.ui_filter_msg(field, first_value, second_value, filt_list = self.filter_list, acc_id = self.friend.id)
                else:
                    for acc in main_prof.accounts:
                        temp_list.extend(self.ui_filter_msg(field, first_value, second_value, filt_list = self.filter_list, acc_id = acc.id))
                self.filter_list = temp_list           
                #print self.filter_list
                self.flag_is_filter = True
                self.end_refresh()
                return

    def ui_filter_msg(self, field, first_value, second_value = None, filt_list = None, acc_id = None):
        """
        it is virtual method
        (need for parameter "poster", in ListFriendsPosts it is empty)
        """
        from ldm.Message import Message
        return Message.filter_msg(field, first_value, second_value, already_found = filt_list, poster = acc_id)
            
    def sort_post_asc(self):
        """
        handler for clicked "asc" button,
        sorts list of current posts in asc order by choosing parameter
        """
        cur_index = self.combo_sort.currentIndex()
        if cur_index == SORT_DATE:
            value = "date"
        elif cur_index == SORT_TITLE:
            value = "title"
        elif cur_index == SORT_READ:
            value = "read"
        from ldm.Message import Message
        
        if self.friend:
            #sort friend's post
            self.filter_list = Message.sort_msg(value, ASC, self.filter_list, poster = [self.friend.id])
        else:
            # sort posts for all user's acoounts
            accounts = []
            for acc in main_prof.accounts:
                accounts.append(acc.id)
            self.filter_list = Message.sort_msg(value, ASC, self.filter_list, poster = accounts )
        #refresh sorted list
        self.flag_is_sort = True
        self.end_refresh()
 
    def sort_post_desc(self):
        """                                                                                                                                                 
        handler for clicked "asc" button,                                                                                                                   
        sorts list of current posts in asc order by choosing parameter                                                                                      
        """
        cur_index = self.combo_sort.currentIndex()
        if cur_index == SORT_DATE:
            value = "date"
        elif cur_index == SORT_TITLE:
            value = "title"
        elif cur_index == SORT_READ:
            value = "read"
        from ldm.Message import Message

        if self.friend:
            #sort friend's post                                                                                                                             
            self.filter_list = Message.sort_msg(value, DESC, self.filter_list, poster = [self.friend.id])
        else:
            # sort posts for all user's acoounts                                                                                                            
            accounts = []
            for acc in main_prof.accounts:
                accounts.append(acc.id)
            self.filter_list = Message.sort_msg(value, DESC, self.filter_list, poster = accounts)
        #refresh sorted list
        self.flag_is_sort = True
        self.end_refresh()




class MyProgress(QtGui.QProgressDialog):
    """
    class with common ProgressBar
    """
    def __init__(self, parent):
        """
        initialization ProgressBar
        """
        QtGui.QProgressDialog.__init__(self, parent)
        self.setLabelText(QtCore.QCoreApplication.translate("MyProgress","Operation is in progress."))
        self.setCancelButtonText(QtCore.QCoreApplication.translate("MyProgress","Cancel"))
        self.parent = parent
        self.setWindowTitle(QtCore.QCoreApplication.translate("MyProgress","Receiving data..."))
        self.setWindowModality(QtCore.Qt.WindowModal)
        self.value_progress = 1.1
        self.setValue(self.value_progress)
        self.forceShow()
        
    def closeEvent(self, event):
        """
        closing progressbar
        """
        self.setValue(self.maximum())
        event.accept()
        self.parent.end_refresh()

from ViewMessage import *

