#
# Keyboard repeat switcher widget for Maemo 5 PR 1.2
# Copyright (c) 2010-05-14 Thomas Perl <thp@thpinfo.com>
# License: GPLv3 or (at your option) any later version
#

import hildondesktop

import gobject
import gtk
import hildon

import gconf

class RepeatSwitcherWidget(hildondesktop.HomePluginItem):
    KEY = '/apps/osso/inputmethod/ext_kb_repeat_enabled'

    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)
        self._client = gconf.Client()
        tb = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        tb.set_label('Repeat keys')
        tb.set_active(self._client.get_bool(self.KEY))
        tb.connect('toggled', self.on_toggled)
        tb.show_all()
        self.add(tb)

    def on_toggled(self, widget):
        self._client.set_bool(self.KEY, widget.get_active())

hd_plugin_type = RepeatSwitcherWidget

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="repeat_switcher")
    obj.show_all()
    gtk.main()

