/*
 * This file is a part of Queen Beecon Widget
 * queen-beecon-dbus-service: Utility for QBW DBUS Service Management
 *
 * http://talk.maemo.org/showthread.php?t=45388
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef QUEEN_BEECON_DBUS_SERVICE_H
#define QUEEN_BEECON_DBUS_SERVICE_H

void queen_beecon_register_dbus_service (QueenBeecon *self, gchar *qbwInstId);

// Methods Callback functions Declarations
gboolean queen_beecon_dbus_cb_dbus_method_monitor (QueenBeecon *self, const gchar *newStatus, GError **error);
gboolean queen_beecon_dbus_cb_reset_rearm_timer (QueenBeecon *self, GError **error);
gboolean queen_beecon_dbus_cb_dbus_show (QueenBeecon *self, GError **error);
gboolean queen_beecon_dbus_cb_dbus_hide (QueenBeecon *self, GError **error);
gboolean queen_beecon_dbus_cb_dbus_wakeup (QueenBeecon *self, GError **error);
gboolean queen_beecon_dbus_cb_dbus_sleep (QueenBeecon *self, GError **error);
gboolean queen_beecon_dbus_cb_dbus_update_content (QueenBeecon *self, GError **error);
gboolean queen_beecon_dbus_cb_dbus_update_layout (QueenBeecon *self, GError **error);
gboolean queen_beecon_dbus_cb_dbus_exec (QueenBeecon *self, const gchar *cmd, GError **error);
gboolean queen_beecon_dbus_cb_dbus_set_param_string (QueenBeecon *self, const gchar *param, const gchar *value, const gchar *update, GError **error);
gboolean queen_beecon_dbus_cb_dbus_set_param_int32 (QueenBeecon *self, const gchar *param, const gint value, const gchar *update, GError **error);
gboolean queen_beecon_dbus_cb_dbus_set_param_uint32 (QueenBeecon *self, const gchar *param, const guint value, const gchar *update, GError **error);
gboolean queen_beecon_dbus_cb_dbus_set_param_double (QueenBeecon *self, const gchar *param, const gdouble value, const gchar *update, GError **error);
gboolean queen_beecon_dbus_cb_dbus_set_param_boolean (QueenBeecon *self, const gchar *param, const gboolean value, const gchar *update, GError **error);
gboolean queen_beecon_dbus_cb_dbus_get_param (QueenBeecon *self, const gchar *param, gchar **value, GError **error);
gboolean queen_beecon_dbus_cb_dbus_is_on_sight (QueenBeecon *self, gchar **value, GError **error);
gboolean queen_beecon_dbus_cb_dbus_get_current_results_text (QueenBeecon *self, gchar **value, GError **error);
gboolean queen_beecon_dbus_cb_dbus_set_position (QueenBeecon *self, const gint widXOrigin, const gint widYOrigin, GError **error);
gboolean queen_beecon_dbus_cb_dbus_get_position (QueenBeecon *self, gint *widXOrigin, gint *widYOrigin, GError **error);
gboolean queen_beecon_dbus_cb_dbus_get_exit_status (QueenBeecon *self, gint *exitStatus, GError **error);
gboolean queen_beecon_dbus_cb_dbus_logger_action (QueenBeecon *self, const gchar *action, GError **error);

#endif /* QUEEN_BEECON_DBUS_SERVICE_H */

