#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QVariant& home1, QVariant& home2, QVariant& defaultHome, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
	ui->home1Entry->setText(home1.toString());
    ui->home1Entry->setInputMethodHints(Qt::ImhDigitsOnly);
	ui->home2Entry->setText(home2.toString());
    ui->home2Entry->setInputMethodHints((Qt::ImhDigitsOnly));
	ui->activeComboBox->setCurrentIndex(defaultHome.toInt());

	this->home1 = &home1;
	this->home2 = &home2;
	this->defaultHome = &defaultHome;

//	this->home1 = new QVariant(home1);
//	this->home2 = new QVariant(home2);
//	this->defaultHome = new QVariant(defaultHome);

    connect(this, SIGNAL(accepted()), this, SLOT(setValues()));
}

SettingsDialog::~SettingsDialog()
{
	delete ui;
}

void SettingsDialog::resizeEvent(QResizeEvent *event){
	if(event->oldSize().width() > event->size().width()){
		ui->mainLayout->setDirection(QBoxLayout::TopToBottom);
	}else{
		ui->mainLayout->setDirection(QBoxLayout::LeftToRight);
	}
}

void SettingsDialog::setValues(){
    home1 = new QVariant(ui->home1Entry->text());
    home2 = new QVariant(ui->home2Entry->text());
    defaultHome = new QVariant(ui->activeComboBox->currentIndex());
}

QVariant* SettingsDialog::getHome1(){
	return home1;
}

QVariant* SettingsDialog::getHome2(){
	return home2;
}

QVariant* SettingsDialog::getDefaultHome(){
	return defaultHome;
}
