import QtQuick 1.0

Rectangle {
	property alias selected: toggle.selected
	property alias zip1: entryfield1.entryPlaceholder
	property alias zip2: entryfield2.entryPlaceholder

	id: setting
//	width: 800
//	height: 480
	width: parent.width
	height: parent.height
	color: "#000000"



 Toggle {
	id: toggle
	x: 200
	y: 110
	height: 80
 anchors.horizontalCenter: parent.horizontalCenter
	opt1Text: "Home 1"
	opt2Text: "Home 2"
	onSelectedChanged: {
		Utilities.setDefaultHome(selected)
	}
 }

 EntryField {
	 id: entryfield1
	  width: 604
	  height: 52
	 text: "Home 1 zipcode"
  anchors.centerIn: parent

	  anchors.verticalCenterOffset: 0
	  opacity: 1
	  onEntryPlaceholderChanged: {
		  Utilities.setHome1(entryPlaceholder)
	  }
 }

 EntryField {
	 id: entryfield2
	 text: "Home 2 zipcode"
  anchors.centerIn: parent
	opacity: 1
	 anchors.verticalCenterOffset: 120
	 anchors.horizontalCenterOffset: 0
	 onEntryPlaceholderChanged: {
		 Utilities.setHome2(entryPlaceholder)
	 }
 }

 states: [
	 State {
		 name: "portrait"
		 PropertyChanges {target: entryfield1; state: "portrait"}
		 PropertyChanges {target: entryfield2; state: "portrait"}
	 }
 ]
}
