/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "Constants.h"

#include <QtGui>
#include <QApplication>
#include <QDebug>


int main(int argc, char *argv[])
{
//	QCoreApplication::setAttribute(Qt::AA_NativeWindows);


//	QString path(QDir::home().path());
//	path.append(QDir::separator()).append(FOLDER);
//
//	QDir folder (path);
//	if (!folder.exists()) {
//		qDebug () << "creating folder " << path;
//		folder.mkdir(path);
//
//		path.append(QDir::separator()).append("qtwallet.db.sqlite");
//		path = QDir::toNativeSeparators(path);
//
//		QString pathold(QDir::home().path());
//		pathold.append(QDir::separator()).append("qtwallet.db.sqlite");
//		pathold = QDir::toNativeSeparators(pathold);
//
//		QFile::rename(pathold, path);
//
//		qDebug () << "move from " << pathold << " to " << path;
//	}


    QApplication app(argc, argv);

    QString lang;
    if (argc > 1) {
    	qDebug () << "setting lang to " << argv [1];
    	lang = argv[1];
    }
    else
    	lang = QLocale::system().name();

    //qDebug () << " SYST = " << QLibraryInfo::location(QLibraryInfo::TranslationsPath) << " IN " << lang;

    QTranslator qtTranslator;
    qtTranslator.load(QString("qt_") + lang,
            QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    //qDebug () << "LANGUAGE " << QLocale::system().name();

    QTranslator myappTranslator;
    qtTranslator.load(QString("/usr/share/qtwallet/translations/qtwallet_") + lang,
            QLibraryInfo::location(QLibraryInfo::TranslationsPath));

    //myappTranslator.load(QString (":/resources/locale/qtwallet_") + lang);
    app.installTranslator(&myappTranslator);

	eWallet * w = new eWallet();
	w->show();
	int ret = app.exec();

	delete ::dbManager;

	delete w;
	return ret;
}
