//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsunlockbutton.h"
#include <QApplication>
#include "lockscreen.h"

LsUnlockButton::LsUnlockButton(QString name) :
        LsButton(name.isEmpty() ? "UnlockButton": name)
{
    m_Timer = new QTimer(this);
    applySettings();
}

void LsUnlockButton::applySettings()
{
    m_Wait = getSetting("WaitTimeMsec", 1000).toInt();
    m_Bkg = QPixmap(getSetting("BackGroundImage", "/opt/qtlockscreen/default/unlock.png").toString());
    m_BkgPressed = QPixmap(getSetting("BackGroundImagePressed", "/opt/qtlockscreen/default/unlockPressed.png").toString());

    m_BkgPressed = m_BkgPressed.scaled(m_Bkg.size());
    setSizeAndPosition(m_Bkg.size(), QPoint(0, 0));

    connect(m_Timer, SIGNAL(timeout()), this, SLOT(onTimer()));
}

void LsUnlockButton::pressed()
{
    m_Timer->stop();
    m_Timer->setInterval(m_Wait);
    m_Timer->setSingleShot(true);
    m_Timer->start();
}

void LsUnlockButton::clicked()
{

}

void LsUnlockButton::released()
{
    m_Timer->stop();
}

void LsUnlockButton::onTimer()
{
    qDebug() << "UnlockButton clicked";
    mouseReleaseEvent(NULL);
#ifdef Q_WS_MAEMO_5
    if (isUnderMouse()){
        QDBusInterface lockScreen("com.nokia.mce", "/com/nokia/mce/request", "com.nokia.mce.request", QDBusConnection::systemBus(), this);
        lockScreen.call("req_tklock_mode_change", "unlocked");
    }
    if (LockScreen::Debug)
        qApp->quit();

#else
    if (isUnderMouse())
        qApp->quit();
#endif
}
