#ifndef SYSTEMFMTX_H
#define SYSTEMFMTX_H

#include <QObject>
#include <QDebug>
#ifdef Q_WS_MAEMO_5
#include <QDBusConnection>
#include <QDBusMessage>
#include <QDBusReply>
#include <QDBusVariant>
#include "dbus/dbus-shared.h"
#include <gq/GConfItem>

#define FMTX_SERVICE "com.nokia.FMTx"
#define FMTX_OBJ_PATH "/com/nokia/fmtx/default"
#define DBUS_PROPERTIES_SET "Set"
#define DBUS_PROPERTIES_GET "Get"
#endif

class SystemFMTX : public QObject
{
    Q_OBJECT
public:
    explicit SystemFMTX(QObject *parent = 0);
    void turnOn();
    void turnOff();
    bool isFMTXAvailable();
    bool isFmtxEnabled();
    /* Reduce developer confusin, I guess ~ MohammadAG */
    bool state();
    void setEnabled(bool enabled);

signals:
    void stateChanged(bool isEnabled);

public slots:

private:
    void setValue(QString property, QVariant value);
    bool m_fmtxEnabled;
#ifdef Q_WS_MAEMO_5
    GConfItem *m_fmtxGConf;
#endif

private slots:
#ifdef Q_WS_MAEMO_5
    void onMaemoFMTXStateChanged();
#endif
};

#endif // SYSTEMFMTX_H
