#ifndef THEMECREATORDLG_H
#define THEMECREATORDLG_H

#include <QtGui/QDialog>
#include "createbuttondlg.h"
#include "createbackgrounddlg.h"
#include "themecreatorbutton.h"
#include "themecreatorbackground.h"
#include "themepreviewbuttondlg.h"
#include "definitions.h"

#include <QFileDialog>
#include <QMessageBox>
#include <QTextStream>
#include <QDateTime>

namespace Ui {
    class ThemeCreatorDlg;
}
class ThemeCreatorDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(ThemeCreatorDlg)
public:
    //! Constructor.
    explicit ThemeCreatorDlg(QWidget *parent = 0);
    //! Destructor.
    virtual ~ThemeCreatorDlg();
    int num;

protected:
    void mousePressEvent(QMouseEvent *event);

private:
    Ui::ThemeCreatorDlg *m_ui;
    CreateButtonDlg *createButtonDlg;
    CreateBackgroundDlg *createBackgroundDlg;
    CreateButtonDlg *cbDlg;
    CreateBackgroundDlg *bgDlg;
    //! Variable for current tab index.
    int tabIndex;
    //! Vector which holds themes buttons.
    QVector <ThemeCreatorButton*> *buttons;
    //! Vector which holds themes backgrounds.
    QVector <ThemeCreatorBackground*> *backgrounds;
    //! Variable for button widgets height in scrollarea.
    int buttonHeight;
    //! Variable for background widgets height in scrollarea.
    int backgroundHeight;
    //! Object for creating new background.
    ThemeCreatorBackground *newBackground;
    //! Holds the current index of selected background.
    int currentBackgroundIndex;
    //! Object for creating new button.
    ThemeCreatorButton *newButton;
    //! Holds the current index of selected button.
    int currentButtonIndex;
    //! Preview buttons path.
    QString previewPath;
    //! Name of preview button.
    QString preview_button;

private slots:
    void on_addButton_clicked();
    void on_editButton_clicked();
    void on_deleteButton_clicked();
    void activateTab(int index);
    void createButton(QString buttonName, QPixmap pressedPix,QPixmap unpressedPix,QFont pressedFont,QFont unpressedFont,bool textEnabled,
                      QString pressedPath,QString unpressedPath);
    void editButton(QString buttonName, QPixmap pressedPix,QPixmap unpressedPix,QFont pressedFont,QFont unpressedFont,bool textEnabled,
                      QString pressedPath,QString unpressedPath);
    void editBackground(QString backgroundName, QPixmap background,QString fileName);
    void createBackground(QString name, QPixmap background,QString fileName);
    void allowSaving();
    void on_saveThemePushButton_clicked();
    void setPreviewPicture(QString picturePath,QString buttonName);
signals:
    void themeCreated();
};
#endif // THEMECREATORDLG_H
