#include "socket.h"
#include <string.h>
#include <errno.h>
#include <fcntl.h>

Socket::Socket(QWidget *parent) :
  QObject(parent),
  m_sock ( -1 )
{

  memset ( &m_addr,
           0,
           sizeof ( m_addr ) );
}

Socket::~Socket()
{
  if ( is_valid() )
    ::close ( m_sock );
}

bool Socket::create()
{
  m_sock = socket ( AF_INET,
                    SOCK_STREAM,
                    0 );

  if ( ! is_valid() )
    return false;

  // TIME_WAIT - argh
  int on = 1;
  if ( setsockopt ( m_sock, SOL_SOCKET, SO_REUSEADDR, ( const char* ) &on, sizeof ( on ) ) == -1 )
    return false;


  return true;

}

void Socket::sendSocket(const QString *action)
{
        const char *buffer;
        int done,todo;
        QString string;

        //if(!isConnected()) return;

        string=*action+"\n";
        QByteArray foo = string.toAscii();
        buffer = foo.data();
        todo=string.length();

        while(todo>0) {
                done=write(m_sock,(void *) buffer,todo);
                if(done<0) {
                        if(errno==EPIPE) {
                               disconnectSocket();
                        }
                        return;
                }
                buffer+=done;
                todo-=done;
        }
}

int Socket::recv ( std::string& s ) const
{
  char buf [ MAXRECV + 1 ];

  s = "";

  memset ( buf, 0, MAXRECV + 1 );

  int status = ::recv ( m_sock, buf, MAXRECV, 0 );

  if ( status == -1 )
    {
     // std::cout << "status == -1   errno == " << errno << "  in Socket::recv\n";
      return 0;
    }
  else if ( status == 0 )
    {
      return 0;
    }
  else
    {
      s = buf;
      return status;
    }
}

bool Socket::connect ( const std::string host, const int port )
{
  if ( ! is_valid() ) return false;

  m_addr.sin_family = AF_INET;
  m_addr.sin_port = htons ( port );

  int status = inet_pton ( AF_INET, host.c_str(), &m_addr.sin_addr );

  if ( errno == EAFNOSUPPORT ) return false;

  status = ::connect ( m_sock, ( sockaddr * ) &m_addr, sizeof ( m_addr ) );

  if ( status == 0 )
    return true;
  else
    return false;
}

int Socket::disconnectSocket()
{
    if ( is_valid() )
        return ::close ( m_sock );
}
