#include "registerdlg.h"
#include "ui_registerdlg.h"

RegisterDlg::RegisterDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::RegisterDlg)
{
    m_ui->setupUi(this);
    this->setWindowTitle("Register to database");

    QUrl url;
    url.setHost("mercury.wipsl.com");
    url.setPath("/qtirreco/webdb/");
    url.setPort(80);

    client = new QxtXmlRpcClient(this, url);
    connect(client,SIGNAL(finish(int,QVariant)),this,SLOT(processReturnValue(int,QVariant)));
    connect(client,SIGNAL(networkError(int,QString)),this,SLOT(error(int,QString)));
    connect(client,SIGNAL(fault(int,int,QString)),this,SLOT(fault(int,int,QString)));

    connect(m_ui->lineEdit,SIGNAL(textChanged(QString)),this,SLOT(allowRegister()));
    connect(m_ui->lineEdit_2,SIGNAL(textChanged(QString)),this,SLOT(allowRegister()));
    connect(m_ui->lineEdit_3,SIGNAL(textChanged(QString)),this,SLOT(allowRegister()));
    connect(m_ui->lineEdit_4,SIGNAL(textChanged(QString)),this,SLOT(allowRegister()));
    m_ui->registerPushButton->setDisabled(true);
}

RegisterDlg::~RegisterDlg()
{
    delete m_ui;
}

void RegisterDlg::on_registerPushButton_clicked()
{
    // TÄHÄN PITÄÄ KEKSIÄ JOKU JÄRKEVÄ KEINO!!!!
    if(m_ui->lineEdit->text().contains(("/"), Qt::CaseInsensitive) || m_ui->lineEdit->text().contains(("'"), Qt::CaseInsensitive)  ||
    m_ui->lineEdit->text().contains(("*"), Qt::CaseInsensitive) || m_ui->lineEdit->text().contains((" "), Qt::CaseInsensitive) ) {
        QMessageBox::warning(this,"Username error ","Username cannot contain special letters like / * ' or space.",
                     QMessageBox::NoButton,QMessageBox::NoButton);
        return;
    }
    else if(m_ui->lineEdit_3->text() == m_ui->lineEdit_4->text()) {
        QByteArray hasharray(QCryptographicHash::hash(m_ui->lineEdit_4->text().toUtf8(),QCryptographicHash::Sha1));
        hasharray = hasharray.toHex();
        QString hashpwd(hasharray);

        QList<QVariant> params;
        params.append(m_ui->lineEdit->text());
        params.append(m_ui->lineEdit_2->text());
        params.append(hashpwd);

        addUserId = client->call("addUser",params);

    }
    else if(m_ui->lineEdit_3->text() != m_ui->lineEdit_4->text()) {
        QMessageBox::warning(this,"Password doesn't match. ","Please enter password again.",
                     QMessageBox::NoButton,QMessageBox::NoButton);

        m_ui->lineEdit_3->clear();
        m_ui->lineEdit_4->clear();
    }


}
void RegisterDlg::allowRegister()
{
    if(!m_ui->lineEdit->text().isEmpty() && !m_ui->lineEdit_2->text().isEmpty() && !m_ui->lineEdit_3->text().isEmpty() &&
       !m_ui->lineEdit_4->text().isEmpty()) {
        m_ui->registerPushButton->setEnabled(true);
    }
    else m_ui->registerPushButton->setDisabled(true);
}
void RegisterDlg::processReturnValue(int Id,QVariant data)
{
    Q_UNUSED(data);
    if (Id == addUserId) {
        QMessageBox::information(this,"Registration","Registration succeeded",
                     QMessageBox::NoButton,QMessageBox::NoButton);
        this->close();
    }
}
void RegisterDlg::error(int i ,QString string)
{
    QMessageBox::warning(this,"Error: "+QString::number(i,10), string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}
void RegisterDlg::fault(int i,int j,QString string)
{
    Q_UNUSED(j);
    QMessageBox::warning(this,"Fault: "+QString::number(i,10),string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}
